--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPowerLevel = {}

---@class fructrl.SetPowerLevelReq
---@field PowerLevel integer
---@field LevelOption integer
local TSetPowerLevelReq = {}
TSetPowerLevelReq.__index = TSetPowerLevelReq
TSetPowerLevelReq.group = {}

local function TSetPowerLevelReq_from_obj(obj)
    return setmetatable(obj, TSetPowerLevelReq)
end

function TSetPowerLevelReq.new(PowerLevel, LevelOption)
    return TSetPowerLevelReq_from_obj({PowerLevel = PowerLevel, LevelOption = LevelOption})
end
---@param obj fructrl.SetPowerLevelReq
function TSetPowerLevelReq:init_from_obj(obj)
    self.PowerLevel = obj.PowerLevel
    self.LevelOption = obj.LevelOption
end

function TSetPowerLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerLevelReq.group)
end

TSetPowerLevelReq.from_obj = TSetPowerLevelReq_from_obj

TSetPowerLevelReq.proto_property = {'PowerLevel', 'LevelOption'}

TSetPowerLevelReq.default = {0, 0}

TSetPowerLevelReq.struct = {
    {name = 'PowerLevel', is_array = false, struct = nil}, {name = 'LevelOption', is_array = false, struct = nil}
}

function TSetPowerLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerLevel', self.PowerLevel, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LevelOption', self.LevelOption, 'uint8', false, errs, need_convert)

    TSetPowerLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerLevelReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerLevelReq:unpack(_)
    return self.PowerLevel, self.LevelOption
end

SetPowerLevel.SetPowerLevelReq = TSetPowerLevelReq

---@class fructrl.SetPowerLevelRsp
---@field CompletionCode integer
local TSetPowerLevelRsp = {}
TSetPowerLevelRsp.__index = TSetPowerLevelRsp
TSetPowerLevelRsp.group = {}

local function TSetPowerLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerLevelRsp)
end

function TSetPowerLevelRsp.new(CompletionCode)
    return TSetPowerLevelRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetPowerLevelRsp
function TSetPowerLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPowerLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerLevelRsp.group)
end

TSetPowerLevelRsp.from_obj = TSetPowerLevelRsp_from_obj

TSetPowerLevelRsp.proto_property = {'CompletionCode'}

TSetPowerLevelRsp.default = {0}

TSetPowerLevelRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPowerLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPowerLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerLevelRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerLevelRsp:unpack(_)
    return self.CompletionCode
end

SetPowerLevel.SetPowerLevelRsp = TSetPowerLevelRsp

return SetPowerLevel
