--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCycleInterval = {}

---@class fructrl.SetCycleIntervalReq
---@field Seconds integer
local TSetCycleIntervalReq = {}
TSetCycleIntervalReq.__index = TSetCycleIntervalReq
TSetCycleIntervalReq.group = {}

local function TSetCycleIntervalReq_from_obj(obj)
    return setmetatable(obj, TSetCycleIntervalReq)
end

function TSetCycleIntervalReq.new(Seconds)
    return TSetCycleIntervalReq_from_obj({Seconds = Seconds})
end
---@param obj fructrl.SetCycleIntervalReq
function TSetCycleIntervalReq:init_from_obj(obj)
    self.Seconds = obj.Seconds
end

function TSetCycleIntervalReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCycleIntervalReq.group)
end

TSetCycleIntervalReq.from_obj = TSetCycleIntervalReq_from_obj

TSetCycleIntervalReq.proto_property = {'Seconds'}

TSetCycleIntervalReq.default = {0}

TSetCycleIntervalReq.struct = {{name = 'Seconds', is_array = false, struct = nil}}

function TSetCycleIntervalReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Seconds', self.Seconds, 'uint8', false, errs, need_convert)

    TSetCycleIntervalReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCycleIntervalReq.proto_property, errs, need_convert)
    return self
end

function TSetCycleIntervalReq:unpack(_)
    return self.Seconds
end

SetCycleInterval.SetCycleIntervalReq = TSetCycleIntervalReq

---@class fructrl.SetCycleIntervalRsp
---@field CompletionCode integer
local TSetCycleIntervalRsp = {}
TSetCycleIntervalRsp.__index = TSetCycleIntervalRsp
TSetCycleIntervalRsp.group = {}

local function TSetCycleIntervalRsp_from_obj(obj)
    return setmetatable(obj, TSetCycleIntervalRsp)
end

function TSetCycleIntervalRsp.new(CompletionCode)
    return TSetCycleIntervalRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetCycleIntervalRsp
function TSetCycleIntervalRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetCycleIntervalRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCycleIntervalRsp.group)
end

TSetCycleIntervalRsp.from_obj = TSetCycleIntervalRsp_from_obj

TSetCycleIntervalRsp.proto_property = {'CompletionCode'}

TSetCycleIntervalRsp.default = {0}

TSetCycleIntervalRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetCycleIntervalRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetCycleIntervalRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCycleIntervalRsp.proto_property, errs, need_convert)
    return self
end

function TSetCycleIntervalRsp:unpack(_)
    return self.CompletionCode
end

SetCycleInterval.SetCycleIntervalRsp = TSetCycleIntervalRsp

return SetCycleInterval
