--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local OEMGetRestartCause = {}

---@class fructrl.OEMGetRestartCauseReq
---@field ManufactureId integer
---@field FruId integer
local TOEMGetRestartCauseReq = {}
TOEMGetRestartCauseReq.__index = TOEMGetRestartCauseReq
TOEMGetRestartCauseReq.group = {}

local function TOEMGetRestartCauseReq_from_obj(obj)
    return setmetatable(obj, TOEMGetRestartCauseReq)
end

function TOEMGetRestartCauseReq.new(ManufactureId, FruId)
    return TOEMGetRestartCauseReq_from_obj({ManufactureId = ManufactureId, FruId = FruId})
end
---@param obj fructrl.OEMGetRestartCauseReq
function TOEMGetRestartCauseReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.FruId = obj.FruId
end

function TOEMGetRestartCauseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMGetRestartCauseReq.group)
end

TOEMGetRestartCauseReq.from_obj = TOEMGetRestartCauseReq_from_obj

TOEMGetRestartCauseReq.proto_property = {'ManufactureId', 'FruId'}

TOEMGetRestartCauseReq.default = {0, 0}

TOEMGetRestartCauseReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil}
}

function TOEMGetRestartCauseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TOEMGetRestartCauseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMGetRestartCauseReq.proto_property, errs, need_convert)
    return self
end

function TOEMGetRestartCauseReq:unpack(_)
    return self.ManufactureId, self.FruId
end

OEMGetRestartCause.OEMGetRestartCauseReq = TOEMGetRestartCauseReq

---@class fructrl.OEMGetRestartCauseRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field RestartCause integer
---@field SrcChan integer
local TOEMGetRestartCauseRsp = {}
TOEMGetRestartCauseRsp.__index = TOEMGetRestartCauseRsp
TOEMGetRestartCauseRsp.group = {}

local function TOEMGetRestartCauseRsp_from_obj(obj)
    return setmetatable(obj, TOEMGetRestartCauseRsp)
end

function TOEMGetRestartCauseRsp.new(CompletionCode, ManufactureId, RestartCause, SrcChan)
    return TOEMGetRestartCauseRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        RestartCause = RestartCause,
        SrcChan = SrcChan
    })
end
---@param obj fructrl.OEMGetRestartCauseRsp
function TOEMGetRestartCauseRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.RestartCause = obj.RestartCause
    self.SrcChan = obj.SrcChan
end

function TOEMGetRestartCauseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMGetRestartCauseRsp.group)
end

TOEMGetRestartCauseRsp.from_obj = TOEMGetRestartCauseRsp_from_obj

TOEMGetRestartCauseRsp.proto_property = {'CompletionCode', 'ManufactureId', 'RestartCause', 'SrcChan'}

TOEMGetRestartCauseRsp.default = {0, 0, 0, 0}

TOEMGetRestartCauseRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'RestartCause', is_array = false, struct = nil}, {name = 'SrcChan', is_array = false, struct = nil}
}

function TOEMGetRestartCauseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SrcChan', self.SrcChan, 'uint8', false, errs, need_convert)

    TOEMGetRestartCauseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMGetRestartCauseRsp.proto_property, errs, need_convert)
    return self
end

function TOEMGetRestartCauseRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.RestartCause, self.SrcChan
end

OEMGetRestartCause.OEMGetRestartCauseRsp = TOEMGetRestartCauseRsp

return OEMGetRestartCause
