--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPowerLevel = {}

---@class fructrl.GetPowerLevelReq
---@field PowerType integer
local TGetPowerLevelReq = {}
TGetPowerLevelReq.__index = TGetPowerLevelReq
TGetPowerLevelReq.group = {}

local function TGetPowerLevelReq_from_obj(obj)
    return setmetatable(obj, TGetPowerLevelReq)
end

function TGetPowerLevelReq.new(PowerType)
    return TGetPowerLevelReq_from_obj({PowerType = PowerType})
end
---@param obj fructrl.GetPowerLevelReq
function TGetPowerLevelReq:init_from_obj(obj)
    self.PowerType = obj.PowerType
end

function TGetPowerLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerLevelReq.group)
end

TGetPowerLevelReq.from_obj = TGetPowerLevelReq_from_obj

TGetPowerLevelReq.proto_property = {'PowerType'}

TGetPowerLevelReq.default = {0}

TGetPowerLevelReq.struct = {{name = 'PowerType', is_array = false, struct = nil}}

function TGetPowerLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerType', self.PowerType, 'uint8', false, errs, need_convert)

    TGetPowerLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerLevelReq.proto_property, errs, need_convert)
    return self
end

function TGetPowerLevelReq:unpack(_)
    return self.PowerType
end

GetPowerLevel.GetPowerLevelReq = TGetPowerLevelReq

---@class fructrl.GetPowerLevelRsp
---@field CompletionCode integer
---@field PowerState integer
---@field DelayToStable integer
---@field PowerMultiplier integer
---@field PowerDraw string
local TGetPowerLevelRsp = {}
TGetPowerLevelRsp.__index = TGetPowerLevelRsp
TGetPowerLevelRsp.group = {}

local function TGetPowerLevelRsp_from_obj(obj)
    return setmetatable(obj, TGetPowerLevelRsp)
end

function TGetPowerLevelRsp.new(CompletionCode, PowerState, DelayToStable, PowerMultiplier, PowerDraw)
    return TGetPowerLevelRsp_from_obj({
        CompletionCode = CompletionCode,
        PowerState = PowerState,
        DelayToStable = DelayToStable,
        PowerMultiplier = PowerMultiplier,
        PowerDraw = PowerDraw
    })
end
---@param obj fructrl.GetPowerLevelRsp
function TGetPowerLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PowerState = obj.PowerState
    self.DelayToStable = obj.DelayToStable
    self.PowerMultiplier = obj.PowerMultiplier
    self.PowerDraw = obj.PowerDraw
end

function TGetPowerLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerLevelRsp.group)
end

TGetPowerLevelRsp.from_obj = TGetPowerLevelRsp_from_obj

TGetPowerLevelRsp.proto_property = {'CompletionCode', 'PowerState', 'DelayToStable', 'PowerMultiplier', 'PowerDraw'}

TGetPowerLevelRsp.default = {0, 0, 0, 0, ''}

TGetPowerLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PowerState', is_array = false, struct = nil},
    {name = 'DelayToStable', is_array = false, struct = nil},
    {name = 'PowerMultiplier', is_array = false, struct = nil}, {name = 'PowerDraw', is_array = false, struct = nil}
}

function TGetPowerLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelayToStable', self.DelayToStable, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PowerMultiplier', self.PowerMultiplier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PowerDraw', self.PowerDraw, 'string', false, errs, need_convert)

    TGetPowerLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerLevelRsp.proto_property, errs, need_convert)
    return self
end

function TGetPowerLevelRsp:unpack(_)
    return self.CompletionCode, self.PowerState, self.DelayToStable, self.PowerMultiplier, self.PowerDraw
end

GetPowerLevel.GetPowerLevelRsp = TGetPowerLevelRsp

return GetPowerLevel
