--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFruActivationPolicy = {}

---@class fructrl.GetFruActivationPolicyReq
---@field FruId integer
local TGetFruActivationPolicyReq = {}
TGetFruActivationPolicyReq.__index = TGetFruActivationPolicyReq
TGetFruActivationPolicyReq.group = {}

local function TGetFruActivationPolicyReq_from_obj(obj)
    return setmetatable(obj, TGetFruActivationPolicyReq)
end

function TGetFruActivationPolicyReq.new(FruId)
    return TGetFruActivationPolicyReq_from_obj({FruId = FruId})
end
---@param obj fructrl.GetFruActivationPolicyReq
function TGetFruActivationPolicyReq:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TGetFruActivationPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruActivationPolicyReq.group)
end

TGetFruActivationPolicyReq.from_obj = TGetFruActivationPolicyReq_from_obj

TGetFruActivationPolicyReq.proto_property = {'FruId'}

TGetFruActivationPolicyReq.default = {0}

TGetFruActivationPolicyReq.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TGetFruActivationPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TGetFruActivationPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruActivationPolicyReq.proto_property, errs, need_convert)
    return self
end

function TGetFruActivationPolicyReq:unpack(_)
    return self.FruId
end

GetFruActivationPolicy.GetFruActivationPolicyReq = TGetFruActivationPolicyReq

---@class fructrl.GetFruActivationPolicyRsp
---@field CompletionCode integer
---@field Policy integer
local TGetFruActivationPolicyRsp = {}
TGetFruActivationPolicyRsp.__index = TGetFruActivationPolicyRsp
TGetFruActivationPolicyRsp.group = {}

local function TGetFruActivationPolicyRsp_from_obj(obj)
    return setmetatable(obj, TGetFruActivationPolicyRsp)
end

function TGetFruActivationPolicyRsp.new(CompletionCode, Policy)
    return TGetFruActivationPolicyRsp_from_obj({CompletionCode = CompletionCode, Policy = Policy})
end
---@param obj fructrl.GetFruActivationPolicyRsp
function TGetFruActivationPolicyRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Policy = obj.Policy
end

function TGetFruActivationPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruActivationPolicyRsp.group)
end

TGetFruActivationPolicyRsp.from_obj = TGetFruActivationPolicyRsp_from_obj

TGetFruActivationPolicyRsp.proto_property = {'CompletionCode', 'Policy'}

TGetFruActivationPolicyRsp.default = {0, 0}

TGetFruActivationPolicyRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Policy', is_array = false, struct = nil}
}

function TGetFruActivationPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Policy', self.Policy, 'uint8', false, errs, need_convert)

    TGetFruActivationPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruActivationPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TGetFruActivationPolicyRsp:unpack(_)
    return self.CompletionCode, self.Policy
end

GetFruActivationPolicy.GetFruActivationPolicyRsp = TGetFruActivationPolicyRsp

return GetFruActivationPolicy
