-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSysReset = {}

---@class MSysReset.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MSysReset.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MSysReset.IsValid = TIsValid

---@class MSysReset.SetSysRstDetected
---@field SetSysRstDetected integer
local TSetSysRstDetected = {}
TSetSysRstDetected.__index = TSetSysRstDetected
TSetSysRstDetected.group = {}

local function TSetSysRstDetected_from_obj(obj)
    return setmetatable(obj, TSetSysRstDetected)
end

function TSetSysRstDetected.new(SetSysRstDetected)
    return TSetSysRstDetected_from_obj({SetSysRstDetected = SetSysRstDetected})
end
---@param obj MSysReset.SetSysRstDetected
function TSetSysRstDetected:init_from_obj(obj)
    self.SetSysRstDetected = obj.SetSysRstDetected
end

function TSetSysRstDetected:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSysRstDetected.group)
end

TSetSysRstDetected.from_obj = TSetSysRstDetected_from_obj

TSetSysRstDetected.proto_property = {'SetSysRstDetected'}

TSetSysRstDetected.default = {0}

TSetSysRstDetected.struct = {{name = 'SetSysRstDetected', is_array = false, struct = nil}}

function TSetSysRstDetected:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetSysRstDetected', self.SetSysRstDetected, 'uint8', false, errs, need_convert)

    TSetSysRstDetected:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSysRstDetected.proto_property, errs, need_convert)
    return self
end

function TSetSysRstDetected:unpack(_)
    return self.SetSysRstDetected
end

MSysReset.SetSysRstDetected = TSetSysRstDetected

---@class MSysReset.GetSysRstDetected
---@field GetSysRstDetected integer
local TGetSysRstDetected = {}
TGetSysRstDetected.__index = TGetSysRstDetected
TGetSysRstDetected.group = {}

local function TGetSysRstDetected_from_obj(obj)
    return setmetatable(obj, TGetSysRstDetected)
end

function TGetSysRstDetected.new(GetSysRstDetected)
    return TGetSysRstDetected_from_obj({GetSysRstDetected = GetSysRstDetected})
end
---@param obj MSysReset.GetSysRstDetected
function TGetSysRstDetected:init_from_obj(obj)
    self.GetSysRstDetected = obj.GetSysRstDetected
end

function TGetSysRstDetected:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSysRstDetected.group)
end

TGetSysRstDetected.from_obj = TGetSysRstDetected_from_obj

TGetSysRstDetected.proto_property = {'GetSysRstDetected'}

TGetSysRstDetected.default = {0}

TGetSysRstDetected.struct = {{name = 'GetSysRstDetected', is_array = false, struct = nil}}

function TGetSysRstDetected:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetSysRstDetected', self.GetSysRstDetected, 'uint8', false, errs, need_convert)

    TGetSysRstDetected:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSysRstDetected.proto_property, errs, need_convert)
    return self
end

function TGetSysRstDetected:unpack(_)
    return self.GetSysRstDetected
end

MSysReset.GetSysRstDetected = TGetSysRstDetected

---@class MSysReset.FruID
---@field FruID integer
local TFruID = {}
TFruID.__index = TFruID
TFruID.group = {}

local function TFruID_from_obj(obj)
    return setmetatable(obj, TFruID)
end

function TFruID.new(FruID)
    return TFruID_from_obj({FruID = FruID or 0})
end
---@param obj MSysReset.FruID
function TFruID:init_from_obj(obj)
    self.FruID = obj.FruID or 0
end

function TFruID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruID.group)
end

TFruID.from_obj = TFruID_from_obj

TFruID.proto_property = {'FruID'}

TFruID.default = {0}

TFruID.struct = {{name = 'FruID', is_array = false, struct = nil}}

function TFruID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruID.proto_property, errs, need_convert)
    return self
end

function TFruID:unpack(_)
    return self.FruID
end

MSysReset.FruID = TFruID

return MSysReset
