-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPowerButton = {}

---@class MPowerButton.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MPowerButton.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MPowerButton.IsValid = TIsValid

---@class MPowerButton.LongPushButton
---@field LongPushButton integer
local TLongPushButton = {}
TLongPushButton.__index = TLongPushButton
TLongPushButton.group = {}

local function TLongPushButton_from_obj(obj)
    return setmetatable(obj, TLongPushButton)
end

function TLongPushButton.new(LongPushButton)
    return TLongPushButton_from_obj({LongPushButton = LongPushButton})
end
---@param obj MPowerButton.LongPushButton
function TLongPushButton:init_from_obj(obj)
    self.LongPushButton = obj.LongPushButton
end

function TLongPushButton:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLongPushButton.group)
end

TLongPushButton.from_obj = TLongPushButton_from_obj

TLongPushButton.proto_property = {'LongPushButton'}

TLongPushButton.default = {0}

TLongPushButton.struct = {{name = 'LongPushButton', is_array = false, struct = nil}}

function TLongPushButton:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LongPushButton', self.LongPushButton, 'uint8', false, errs, need_convert)

    TLongPushButton:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLongPushButton.proto_property, errs, need_convert)
    return self
end

function TLongPushButton:unpack(_)
    return self.LongPushButton
end

MPowerButton.LongPushButton = TLongPushButton

---@class MPowerButton.ShortPushButton
---@field ShortPushButton integer
local TShortPushButton = {}
TShortPushButton.__index = TShortPushButton
TShortPushButton.group = {}

local function TShortPushButton_from_obj(obj)
    return setmetatable(obj, TShortPushButton)
end

function TShortPushButton.new(ShortPushButton)
    return TShortPushButton_from_obj({ShortPushButton = ShortPushButton})
end
---@param obj MPowerButton.ShortPushButton
function TShortPushButton:init_from_obj(obj)
    self.ShortPushButton = obj.ShortPushButton
end

function TShortPushButton:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShortPushButton.group)
end

TShortPushButton.from_obj = TShortPushButton_from_obj

TShortPushButton.proto_property = {'ShortPushButton'}

TShortPushButton.default = {0}

TShortPushButton.struct = {{name = 'ShortPushButton', is_array = false, struct = nil}}

function TShortPushButton:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ShortPushButton', self.ShortPushButton, 'uint8', false, errs, need_convert)

    TShortPushButton:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShortPushButton.proto_property, errs, need_convert)
    return self
end

function TShortPushButton:unpack(_)
    return self.ShortPushButton
end

MPowerButton.ShortPushButton = TShortPushButton

---@class MPowerButton.FruID
---@field FruID integer
local TFruID = {}
TFruID.__index = TFruID
TFruID.group = {}

local function TFruID_from_obj(obj)
    return setmetatable(obj, TFruID)
end

function TFruID.new(FruID)
    return TFruID_from_obj({FruID = FruID or 0})
end
---@param obj MPowerButton.FruID
function TFruID:init_from_obj(obj)
    self.FruID = obj.FruID or 0
end

function TFruID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruID.group)
end

TFruID.from_obj = TFruID_from_obj

TFruID.proto_property = {'FruID'}

TFruID.default = {0}

TFruID.struct = {{name = 'FruID', is_array = false, struct = nil}}

function TFruID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruID.proto_property, errs, need_convert)
    return self
end

function TFruID:unpack(_)
    return self.FruID
end

MPowerButton.FruID = TFruID

return MPowerButton
