-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MChassisFruCtrl = {}

---@class MChassisFruCtrl.PowerCycleState
---@field PowerCycleState integer
local TPowerCycleState = {}
TPowerCycleState.__index = TPowerCycleState
TPowerCycleState.group = {}

local function TPowerCycleState_from_obj(obj)
    return setmetatable(obj, TPowerCycleState)
end

function TPowerCycleState.new(PowerCycleState)
    return TPowerCycleState_from_obj({PowerCycleState = PowerCycleState or 0})
end
---@param obj MChassisFruCtrl.PowerCycleState
function TPowerCycleState:init_from_obj(obj)
    self.PowerCycleState = obj.PowerCycleState or 0
end

function TPowerCycleState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCycleState.group)
end

TPowerCycleState.from_obj = TPowerCycleState_from_obj

TPowerCycleState.proto_property = {'PowerCycleState'}

TPowerCycleState.default = {0}

TPowerCycleState.struct = {{name = 'PowerCycleState', is_array = false, struct = nil}}

function TPowerCycleState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCycleState', self.PowerCycleState, 'uint8', false, errs, need_convert)

    TPowerCycleState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCycleState.proto_property, errs, need_convert)
    return self
end

function TPowerCycleState:unpack(_)
    return self.PowerCycleState
end

MChassisFruCtrl.PowerCycleState = TPowerCycleState

---@class MChassisFruCtrl.PowerCycleType
---@field PowerCycleType integer
local TPowerCycleType = {}
TPowerCycleType.__index = TPowerCycleType
TPowerCycleType.group = {}

local function TPowerCycleType_from_obj(obj)
    return setmetatable(obj, TPowerCycleType)
end

function TPowerCycleType.new(PowerCycleType)
    return TPowerCycleType_from_obj({PowerCycleType = PowerCycleType or 0})
end
---@param obj MChassisFruCtrl.PowerCycleType
function TPowerCycleType:init_from_obj(obj)
    self.PowerCycleType = obj.PowerCycleType or 0
end

function TPowerCycleType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCycleType.group)
end

TPowerCycleType.from_obj = TPowerCycleType_from_obj

TPowerCycleType.proto_property = {'PowerCycleType'}

TPowerCycleType.default = {0}

TPowerCycleType.struct = {{name = 'PowerCycleType', is_array = false, struct = nil}}

function TPowerCycleType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCycleType', self.PowerCycleType, 'uint8', false, errs, need_convert)

    TPowerCycleType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCycleType.proto_property, errs, need_convert)
    return self
end

function TPowerCycleType:unpack(_)
    return self.PowerCycleType
end

MChassisFruCtrl.PowerCycleType = TPowerCycleType

---@class MChassisFruCtrl.PowerCycleInterval
---@field PowerCycleInterval integer
local TPowerCycleInterval = {}
TPowerCycleInterval.__index = TPowerCycleInterval
TPowerCycleInterval.group = {}

local function TPowerCycleInterval_from_obj(obj)
    return setmetatable(obj, TPowerCycleInterval)
end

function TPowerCycleInterval.new(PowerCycleInterval)
    return TPowerCycleInterval_from_obj({PowerCycleInterval = PowerCycleInterval or 10})
end
---@param obj MChassisFruCtrl.PowerCycleInterval
function TPowerCycleInterval:init_from_obj(obj)
    self.PowerCycleInterval = obj.PowerCycleInterval or 10
end

function TPowerCycleInterval:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCycleInterval.group)
end

TPowerCycleInterval.from_obj = TPowerCycleInterval_from_obj

TPowerCycleInterval.proto_property = {'PowerCycleInterval'}

TPowerCycleInterval.default = {0}

TPowerCycleInterval.struct = {{name = 'PowerCycleInterval', is_array = false, struct = nil}}

function TPowerCycleInterval:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCycleInterval', self.PowerCycleInterval, 'uint8', false, errs, need_convert)

    TPowerCycleInterval:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCycleInterval.proto_property, errs, need_convert)
    return self
end

function TPowerCycleInterval:unpack(_)
    return self.PowerCycleInterval
end

MChassisFruCtrl.PowerCycleInterval = TPowerCycleInterval

---@class MChassisFruCtrl.StaggeredPowerOnInterval
---@field StaggeredPowerOnInterval integer
local TStaggeredPowerOnInterval = {}
TStaggeredPowerOnInterval.__index = TStaggeredPowerOnInterval
TStaggeredPowerOnInterval.group = {}

local function TStaggeredPowerOnInterval_from_obj(obj)
    return setmetatable(obj, TStaggeredPowerOnInterval)
end

function TStaggeredPowerOnInterval.new(StaggeredPowerOnInterval)
    return TStaggeredPowerOnInterval_from_obj({StaggeredPowerOnInterval = StaggeredPowerOnInterval or 60})
end
---@param obj MChassisFruCtrl.StaggeredPowerOnInterval
function TStaggeredPowerOnInterval:init_from_obj(obj)
    self.StaggeredPowerOnInterval = obj.StaggeredPowerOnInterval or 60
end

function TStaggeredPowerOnInterval:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStaggeredPowerOnInterval.group)
end

TStaggeredPowerOnInterval.from_obj = TStaggeredPowerOnInterval_from_obj

TStaggeredPowerOnInterval.proto_property = {'StaggeredPowerOnInterval'}

TStaggeredPowerOnInterval.default = {0}

TStaggeredPowerOnInterval.struct = {{name = 'StaggeredPowerOnInterval', is_array = false, struct = nil}}

function TStaggeredPowerOnInterval:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StaggeredPowerOnInterval', self.StaggeredPowerOnInterval, 'uint8', false, errs,
        need_convert)

    TStaggeredPowerOnInterval:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStaggeredPowerOnInterval.proto_property, errs, need_convert)
    return self
end

function TStaggeredPowerOnInterval:unpack(_)
    return self.StaggeredPowerOnInterval
end

MChassisFruCtrl.StaggeredPowerOnInterval = TStaggeredPowerOnInterval

---@class MChassisFruCtrl.PowerGDState
---@field PowerGDState integer
local TPowerGDState = {}
TPowerGDState.__index = TPowerGDState
TPowerGDState.group = {}

local function TPowerGDState_from_obj(obj)
    return setmetatable(obj, TPowerGDState)
end

function TPowerGDState.new(PowerGDState)
    return TPowerGDState_from_obj({PowerGDState = PowerGDState})
end
---@param obj MChassisFruCtrl.PowerGDState
function TPowerGDState:init_from_obj(obj)
    self.PowerGDState = obj.PowerGDState
end

function TPowerGDState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerGDState.group)
end

TPowerGDState.from_obj = TPowerGDState_from_obj

TPowerGDState.proto_property = {'PowerGDState'}

TPowerGDState.default = {0}

TPowerGDState.struct = {{name = 'PowerGDState', is_array = false, struct = nil}}

function TPowerGDState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerGDState', self.PowerGDState, 'uint8', false, errs, need_convert)

    TPowerGDState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerGDState.proto_property, errs, need_convert)
    return self
end

function TPowerGDState:unpack(_)
    return self.PowerGDState
end

MChassisFruCtrl.PowerGDState = TPowerGDState

---@class MChassisFruCtrl.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MChassisFruCtrl.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MChassisFruCtrl.Id = TId

return MChassisFruCtrl
