-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MACCycle = {}

---@class MACCycle.AC
---@field AC integer
local TAC = {}
TAC.__index = TAC
TAC.group = {}

local function TAC_from_obj(obj)
    return setmetatable(obj, TAC)
end

function TAC.new(AC)
    return TAC_from_obj({AC = AC})
end
---@param obj MACCycle.AC
function TAC:init_from_obj(obj)
    self.AC = obj.AC
end

function TAC:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAC.group)
end

TAC.from_obj = TAC_from_obj

TAC.proto_property = {'AC'}

TAC.default = {0}

TAC.struct = {{name = 'AC', is_array = false, struct = nil}}

function TAC:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AC', self.AC, 'uint8', false, errs, need_convert)

    TAC:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAC.proto_property, errs, need_convert)
    return self
end

function TAC:unpack(_)
    return self.AC
end

MACCycle.AC = TAC

return MACCycle
