-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local common_utils = require 'common_tools.common_utils'

TestCommonUtils = {}

function TestCommonUtils:test_validate_byte_and_trim()
    lu.assertIsFalse(common_utils.validate_byte("Location", "\r"))
    lu.assertIsTrue(common_utils.validate_byte("Location", "2"))
    lu.assertIsTrue(common_utils.trim("") == "")
    lu.assertIsTrue(common_utils.trim(" w w ") == 'w w')
end