-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 数据采集集成测试用例
local lu = require 'luaunit'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local context = require'mc.context'

local test_metric = {}

-- GetItems接口
local function test_get_items(bus)
    local component, classification, identification, metricName = bus:call('bmc.kepler.chassis', 
        '/bmc/kepler/Chassis/1', 'bmc.kepler.Metric', 'GetItems', 'a{ss}', context.new())
    lu.assertEquals(component, 'Chassis')
    lu.assertEquals(classification[1][1], 'SystemName')
    lu.assertEquals(identification[2][1], 'DeviceSerialNumber')
    lu.assertEquals(metricName[2], 'chassis.outlettemp')
    return metricName
end

-- GetData接口
local function test_get_data(bus, metricName)
    local val = bus:call('bmc.kepler.chassis', '/bmc/kepler/Chassis/1', 
        'bmc.kepler.Metric', 'GetData', 'a{ss}as', context.new(), metricName)
    lu.assertEquals(#val, 2)
    lu.assertEquals(val[1][2][1], '0.000')
    lu.assertEquals(val[2][2][1], '0.000')
end

function test_metric.test_all_metric_method(bus)
    log:info('================ test metric method start ================')
    local metricName = test_get_items(bus)
    test_get_data(bus, metricName)
    log:info('================ test metric method end ================')
end

return test_metric