-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local log = require 'mc.logging'
local mc_context = require 'mc.context'
local json = require 'cjson'
local lu = require 'luaunit'

local context = mc_context.new('IT', 'Admin', '127.0.0.1')

local test_business_config = {}

local function test_superpod_label_import(bus, service, path, intf)
    local data = json.encode({
        ConfigData = {
            SuperPodLabel = {
                SuperPodId = { Value = 16, Import = true },
                ServerIndex = { Value = 32, Import = true },
                SuperPodSize = { Value = 64, Import = true },
            },
        }
    })
    bus:call(service, path, intf, 'Import', 'a{ss}ss', context, data, 'configuration')
end

local function test_on_import(bus)
    -- 当前回调函数不支持代理对象访问，这里直接使用busctl访问方式进行测试
    -- 使用导出功能进行验证
    local service = 'bmc.kepler.chassis'
    local path = '/bmc/kepler/chassis/MicroComponent'
    local intf = 'bmc.kepler.MicroComponent.ConfigManage'

    test_superpod_label_import(bus, service, path, intf)
end

local function test_superpod_label_export(data)
    assert(data)
    assert(data.ConfigData)
    assert(data.ConfigData.SuperPodLabel)
    assert(data.ConfigData.SuperPodLabel.SuperPodId == 16)
    assert(data.ConfigData.SuperPodLabel.ServerIndex == 32)
    assert(data.ConfigData.SuperPodLabel.SuperPodSize == 64)
end

local function test_on_export(bus)
    -- 当前回调函数不支持代理对象访问，这里直接使用busctl访问方式进行测试
    local service = 'bmc.kepler.chassis'
    local path = '/bmc/kepler/chassis/MicroComponent'
    local intf = 'bmc.kepler.MicroComponent.ConfigManage'
    local ret = bus:call(service, path, intf, 'Export', 'a{ss}s', context, 'configuration')
    assert(ret)
    local data = json.decode(ret)

    test_superpod_label_export(data)
end

function test_business_config.main(bus)
    log:notice('================ test config import and export start ================')
    test_on_import(bus)
    test_on_export(bus)

    log:notice('================ test config import and export complete ================')
end

return test_business_config
