-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local chassis_def = require 'def.chassis_def'

local ncsi_capabilities_object = {}
ncsi_capabilities_object.__index = ncsi_capabilities_object

local DEVICE_ID<const> = 13

function ncsi_capabilities_object.new_for_csr(obj)
    return setmetatable({obj = obj}, ncsi_capabilities_object)
end

function ncsi_capabilities_object:get_prop_by_id(id)
    if not self.obj then
        return nil
    end
    local prop_name = chassis_def.DEVICEID_MAP[id]
    if prop_name == nil then
        return nil
    end
    if id == DEVICE_ID then
        return 0
    end
    return self.obj[prop_name]
end

return ncsi_capabilities_object