-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local client = require 'chassis.client'
local log = require 'mc.logging'
local tool = {}

-- 获取互联网定制化厂商
function tool.get_customer()
    local ok, package_objs = pcall(function()
        return client:GetPackageObjects()['/bmc/kepler/Managers/1/Package']
    end)
    if not ok or not package_objs then
        log:error('Get package objects failed')
        return ''
    end
    local customer = package_objs.Customer
    if customer == nil then
        log:error('Get customer failed')
        return ''
    end
    return customer
end

return tool
