-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLedDispControl = {}

---@class MLedDispControl.RightLedTube
---@field RightLedTube integer
local TRightLedTube = {}
TRightLedTube.__index = TRightLedTube
TRightLedTube.group = {}

local function TRightLedTube_from_obj(obj)
    return setmetatable(obj, TRightLedTube)
end

function TRightLedTube.new(RightLedTube)
    return TRightLedTube_from_obj({RightLedTube = RightLedTube or 0})
end
---@param obj MLedDispControl.RightLedTube
function TRightLedTube:init_from_obj(obj)
    self.RightLedTube = obj.RightLedTube or 0
end

function TRightLedTube:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRightLedTube.group)
end

TRightLedTube.from_obj = TRightLedTube_from_obj

TRightLedTube.proto_property = {'RightLedTube'}

TRightLedTube.default = {0}

TRightLedTube.struct = {{name = 'RightLedTube', is_array = false, struct = nil}}

function TRightLedTube:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RightLedTube', self.RightLedTube, 'uint8', false, errs, need_convert)

    TRightLedTube:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRightLedTube.proto_property, errs, need_convert)
    return self
end

function TRightLedTube:unpack(_)
    return self.RightLedTube
end

MLedDispControl.RightLedTube = TRightLedTube

---@class MLedDispControl.MidLedTube
---@field MidLedTube integer
local TMidLedTube = {}
TMidLedTube.__index = TMidLedTube
TMidLedTube.group = {}

local function TMidLedTube_from_obj(obj)
    return setmetatable(obj, TMidLedTube)
end

function TMidLedTube.new(MidLedTube)
    return TMidLedTube_from_obj({MidLedTube = MidLedTube or 0})
end
---@param obj MLedDispControl.MidLedTube
function TMidLedTube:init_from_obj(obj)
    self.MidLedTube = obj.MidLedTube or 0
end

function TMidLedTube:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMidLedTube.group)
end

TMidLedTube.from_obj = TMidLedTube_from_obj

TMidLedTube.proto_property = {'MidLedTube'}

TMidLedTube.default = {0}

TMidLedTube.struct = {{name = 'MidLedTube', is_array = false, struct = nil}}

function TMidLedTube:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MidLedTube', self.MidLedTube, 'uint8', false, errs, need_convert)

    TMidLedTube:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMidLedTube.proto_property, errs, need_convert)
    return self
end

function TMidLedTube:unpack(_)
    return self.MidLedTube
end

MLedDispControl.MidLedTube = TMidLedTube

---@class MLedDispControl.LeftLedTube
---@field LeftLedTube integer
local TLeftLedTube = {}
TLeftLedTube.__index = TLeftLedTube
TLeftLedTube.group = {}

local function TLeftLedTube_from_obj(obj)
    return setmetatable(obj, TLeftLedTube)
end

function TLeftLedTube.new(LeftLedTube)
    return TLeftLedTube_from_obj({LeftLedTube = LeftLedTube or 0})
end
---@param obj MLedDispControl.LeftLedTube
function TLeftLedTube:init_from_obj(obj)
    self.LeftLedTube = obj.LeftLedTube or 0
end

function TLeftLedTube:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLeftLedTube.group)
end

TLeftLedTube.from_obj = TLeftLedTube_from_obj

TLeftLedTube.proto_property = {'LeftLedTube'}

TLeftLedTube.default = {0}

TLeftLedTube.struct = {{name = 'LeftLedTube', is_array = false, struct = nil}}

function TLeftLedTube:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LeftLedTube', self.LeftLedTube, 'uint8', false, errs, need_convert)

    TLeftLedTube:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLeftLedTube.proto_property, errs, need_convert)
    return self
end

function TLeftLedTube:unpack(_)
    return self.LeftLedTube
end

MLedDispControl.LeftLedTube = TLeftLedTube

---@class MLedDispControl.LedTubeSupport
---@field LedTubeSupport boolean
local TLedTubeSupport = {}
TLedTubeSupport.__index = TLedTubeSupport
TLedTubeSupport.group = {}

local function TLedTubeSupport_from_obj(obj)
    return setmetatable(obj, TLedTubeSupport)
end

function TLedTubeSupport.new(LedTubeSupport)
    return TLedTubeSupport_from_obj({LedTubeSupport = LedTubeSupport or false})
end
---@param obj MLedDispControl.LedTubeSupport
function TLedTubeSupport:init_from_obj(obj)
    self.LedTubeSupport = obj.LedTubeSupport or false
end

function TLedTubeSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLedTubeSupport.group)
end

TLedTubeSupport.from_obj = TLedTubeSupport_from_obj

TLedTubeSupport.proto_property = {'LedTubeSupport'}

TLedTubeSupport.default = {false}

TLedTubeSupport.struct = {{name = 'LedTubeSupport', is_array = false, struct = nil}}

function TLedTubeSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LedTubeSupport', self.LedTubeSupport, 'bool', false, errs, need_convert)

    TLedTubeSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLedTubeSupport.proto_property, errs, need_convert)
    return self
end

function TLedTubeSupport:unpack(_)
    return self.LedTubeSupport
end

MLedDispControl.LedTubeSupport = TLedTubeSupport

return MLedDispControl
