-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftButtonTest = {}

---@class MDftButtonTest.ClearPressEvent
---@field ClearPressEvent integer
local TClearPressEvent = {}
TClearPressEvent.__index = TClearPressEvent
TClearPressEvent.group = {}

local function TClearPressEvent_from_obj(obj)
    return setmetatable(obj, TClearPressEvent)
end

function TClearPressEvent.new(ClearPressEvent)
    return TClearPressEvent_from_obj({ClearPressEvent = ClearPressEvent})
end
---@param obj MDftButtonTest.ClearPressEvent
function TClearPressEvent:init_from_obj(obj)
    self.ClearPressEvent = obj.ClearPressEvent
end

function TClearPressEvent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearPressEvent.group)
end

TClearPressEvent.from_obj = TClearPressEvent_from_obj

TClearPressEvent.proto_property = {'ClearPressEvent'}

TClearPressEvent.default = {0}

TClearPressEvent.struct = {{name = 'ClearPressEvent', is_array = false, struct = nil}}

function TClearPressEvent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ClearPressEvent', self.ClearPressEvent, 'uint8', false, errs, need_convert)

    TClearPressEvent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearPressEvent.proto_property, errs, need_convert)
    return self
end

function TClearPressEvent:unpack(_)
    return self.ClearPressEvent
end

MDftButtonTest.ClearPressEvent = TClearPressEvent

---@class MDftButtonTest.ExpectedValue
---@field ExpectedValue integer
local TExpectedValue = {}
TExpectedValue.__index = TExpectedValue
TExpectedValue.group = {}

local function TExpectedValue_from_obj(obj)
    return setmetatable(obj, TExpectedValue)
end

function TExpectedValue.new(ExpectedValue)
    return TExpectedValue_from_obj({ExpectedValue = ExpectedValue})
end
---@param obj MDftButtonTest.ExpectedValue
function TExpectedValue:init_from_obj(obj)
    self.ExpectedValue = obj.ExpectedValue
end

function TExpectedValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectedValue.group)
end

TExpectedValue.from_obj = TExpectedValue_from_obj

TExpectedValue.proto_property = {'ExpectedValue'}

TExpectedValue.default = {0}

TExpectedValue.struct = {{name = 'ExpectedValue', is_array = false, struct = nil}}

function TExpectedValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectedValue', self.ExpectedValue, 'uint8', false, errs, need_convert)

    TExpectedValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectedValue.proto_property, errs, need_convert)
    return self
end

function TExpectedValue:unpack(_)
    return self.ExpectedValue
end

MDftButtonTest.ExpectedValue = TExpectedValue

---@class MDftButtonTest.PressEvent
---@field PressEvent integer
local TPressEvent = {}
TPressEvent.__index = TPressEvent
TPressEvent.group = {}

local function TPressEvent_from_obj(obj)
    return setmetatable(obj, TPressEvent)
end

function TPressEvent.new(PressEvent)
    return TPressEvent_from_obj({PressEvent = PressEvent})
end
---@param obj MDftButtonTest.PressEvent
function TPressEvent:init_from_obj(obj)
    self.PressEvent = obj.PressEvent
end

function TPressEvent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPressEvent.group)
end

TPressEvent.from_obj = TPressEvent_from_obj

TPressEvent.proto_property = {'PressEvent'}

TPressEvent.default = {0}

TPressEvent.struct = {{name = 'PressEvent', is_array = false, struct = nil}}

function TPressEvent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PressEvent', self.PressEvent, 'uint8', false, errs, need_convert)

    TPressEvent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPressEvent.proto_property, errs, need_convert)
    return self
end

function TPressEvent:unpack(_)
    return self.PressEvent
end

MDftButtonTest.PressEvent = TPressEvent

return MDftButtonTest
