-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MChassisTable = {}

---@class MChassisTable.ProcessRestartFlag
---@field ProcessRestartFlag integer
local TProcessRestartFlag = {}
TProcessRestartFlag.__index = TProcessRestartFlag
TProcessRestartFlag.group = {}

local function TProcessRestartFlag_from_obj(obj)
    return setmetatable(obj, TProcessRestartFlag)
end

function TProcessRestartFlag.new(ProcessRestartFlag)
    return TProcessRestartFlag_from_obj({ProcessRestartFlag = ProcessRestartFlag or 0})
end
---@param obj MChassisTable.ProcessRestartFlag
function TProcessRestartFlag:init_from_obj(obj)
    self.ProcessRestartFlag = obj.ProcessRestartFlag or 0
end

function TProcessRestartFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessRestartFlag.group)
end

TProcessRestartFlag.from_obj = TProcessRestartFlag_from_obj

TProcessRestartFlag.proto_property = {'ProcessRestartFlag'}

TProcessRestartFlag.default = {0}

TProcessRestartFlag.struct = {{name = 'ProcessRestartFlag', is_array = false, struct = nil}}

function TProcessRestartFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessRestartFlag', self.ProcessRestartFlag, 'uint8', false, errs, need_convert)

    TProcessRestartFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessRestartFlag.proto_property, errs, need_convert)
    return self
end

function TProcessRestartFlag:unpack(_)
    return self.ProcessRestartFlag
end

MChassisTable.ProcessRestartFlag = TProcessRestartFlag

---@class MChassisTable.BmcHardResetFlag
---@field BmcHardResetFlag integer
local TBmcHardResetFlag = {}
TBmcHardResetFlag.__index = TBmcHardResetFlag
TBmcHardResetFlag.group = {}

local function TBmcHardResetFlag_from_obj(obj)
    return setmetatable(obj, TBmcHardResetFlag)
end

function TBmcHardResetFlag.new(BmcHardResetFlag)
    return TBmcHardResetFlag_from_obj({BmcHardResetFlag = BmcHardResetFlag or 0})
end
---@param obj MChassisTable.BmcHardResetFlag
function TBmcHardResetFlag:init_from_obj(obj)
    self.BmcHardResetFlag = obj.BmcHardResetFlag or 0
end

function TBmcHardResetFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBmcHardResetFlag.group)
end

TBmcHardResetFlag.from_obj = TBmcHardResetFlag_from_obj

TBmcHardResetFlag.proto_property = {'BmcHardResetFlag'}

TBmcHardResetFlag.default = {0}

TBmcHardResetFlag.struct = {{name = 'BmcHardResetFlag', is_array = false, struct = nil}}

function TBmcHardResetFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BmcHardResetFlag', self.BmcHardResetFlag, 'uint8', false, errs, need_convert)

    TBmcHardResetFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBmcHardResetFlag.proto_property, errs, need_convert)
    return self
end

function TBmcHardResetFlag:unpack(_)
    return self.BmcHardResetFlag
end

MChassisTable.BmcHardResetFlag = TBmcHardResetFlag

---@class MChassisTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MChassisTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MChassisTable.Id = TId

return MChassisTable
