-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MChassis = {}

---@class MChassis.UidButtonTestStatus
---@field UidButtonTestStatus integer
local TUidButtonTestStatus = {}
TUidButtonTestStatus.__index = TUidButtonTestStatus
TUidButtonTestStatus.group = {}

local function TUidButtonTestStatus_from_obj(obj)
    return setmetatable(obj, TUidButtonTestStatus)
end

function TUidButtonTestStatus.new(UidButtonTestStatus)
    return TUidButtonTestStatus_from_obj({UidButtonTestStatus = UidButtonTestStatus or 129})
end
---@param obj MChassis.UidButtonTestStatus
function TUidButtonTestStatus:init_from_obj(obj)
    self.UidButtonTestStatus = obj.UidButtonTestStatus or 129
end

function TUidButtonTestStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonTestStatus.group)
end

TUidButtonTestStatus.from_obj = TUidButtonTestStatus_from_obj

TUidButtonTestStatus.proto_property = {'UidButtonTestStatus'}

TUidButtonTestStatus.default = {0}

TUidButtonTestStatus.struct = {{name = 'UidButtonTestStatus', is_array = false, struct = nil}}

function TUidButtonTestStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonTestStatus', self.UidButtonTestStatus, 'uint8', false, errs, need_convert)

    TUidButtonTestStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonTestStatus.proto_property, errs, need_convert)
    return self
end

function TUidButtonTestStatus:unpack(_)
    return self.UidButtonTestStatus
end

MChassis.UidButtonTestStatus = TUidButtonTestStatus

---@class MChassis.UidButtonTestResult
---@field UidButtonTestResult integer
local TUidButtonTestResult = {}
TUidButtonTestResult.__index = TUidButtonTestResult
TUidButtonTestResult.group = {}

local function TUidButtonTestResult_from_obj(obj)
    return setmetatable(obj, TUidButtonTestResult)
end

function TUidButtonTestResult.new(UidButtonTestResult)
    return TUidButtonTestResult_from_obj({UidButtonTestResult = UidButtonTestResult or 255})
end
---@param obj MChassis.UidButtonTestResult
function TUidButtonTestResult:init_from_obj(obj)
    self.UidButtonTestResult = obj.UidButtonTestResult or 255
end

function TUidButtonTestResult:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonTestResult.group)
end

TUidButtonTestResult.from_obj = TUidButtonTestResult_from_obj

TUidButtonTestResult.proto_property = {'UidButtonTestResult'}

TUidButtonTestResult.default = {0}

TUidButtonTestResult.struct = {{name = 'UidButtonTestResult', is_array = false, struct = nil}}

function TUidButtonTestResult:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonTestResult', self.UidButtonTestResult, 'uint8', false, errs, need_convert)

    TUidButtonTestResult:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonTestResult.proto_property, errs, need_convert)
    return self
end

function TUidButtonTestResult:unpack(_)
    return self.UidButtonTestResult
end

MChassis.UidButtonTestResult = TUidButtonTestResult

---@class MChassis.UidButtonTestFlag
---@field UidButtonTestFlag boolean
local TUidButtonTestFlag = {}
TUidButtonTestFlag.__index = TUidButtonTestFlag
TUidButtonTestFlag.group = {}

local function TUidButtonTestFlag_from_obj(obj)
    return setmetatable(obj, TUidButtonTestFlag)
end

function TUidButtonTestFlag.new(UidButtonTestFlag)
    return TUidButtonTestFlag_from_obj({UidButtonTestFlag = UidButtonTestFlag == nil and true or UidButtonTestFlag})
end
---@param obj MChassis.UidButtonTestFlag
function TUidButtonTestFlag:init_from_obj(obj)
    self.UidButtonTestFlag = obj.UidButtonTestFlag == nil and true or obj.UidButtonTestFlag
end

function TUidButtonTestFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonTestFlag.group)
end

TUidButtonTestFlag.from_obj = TUidButtonTestFlag_from_obj

TUidButtonTestFlag.proto_property = {'UidButtonTestFlag'}

TUidButtonTestFlag.default = {false}

TUidButtonTestFlag.struct = {{name = 'UidButtonTestFlag', is_array = false, struct = nil}}

function TUidButtonTestFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonTestFlag', self.UidButtonTestFlag, 'bool', false, errs, need_convert)

    TUidButtonTestFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonTestFlag.proto_property, errs, need_convert)
    return self
end

function TUidButtonTestFlag:unpack(_)
    return self.UidButtonTestFlag
end

MChassis.UidButtonTestFlag = TUidButtonTestFlag

---@class MChassis.UidButtonLongScanner
---@field UidButtonLongScanner integer
local TUidButtonLongScanner = {}
TUidButtonLongScanner.__index = TUidButtonLongScanner
TUidButtonLongScanner.group = {}

local function TUidButtonLongScanner_from_obj(obj)
    return setmetatable(obj, TUidButtonLongScanner)
end

function TUidButtonLongScanner.new(UidButtonLongScanner)
    return TUidButtonLongScanner_from_obj({UidButtonLongScanner = UidButtonLongScanner})
end
---@param obj MChassis.UidButtonLongScanner
function TUidButtonLongScanner:init_from_obj(obj)
    self.UidButtonLongScanner = obj.UidButtonLongScanner
end

function TUidButtonLongScanner:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonLongScanner.group)
end

TUidButtonLongScanner.from_obj = TUidButtonLongScanner_from_obj

TUidButtonLongScanner.proto_property = {'UidButtonLongScanner'}

TUidButtonLongScanner.default = {0}

TUidButtonLongScanner.struct = {{name = 'UidButtonLongScanner', is_array = false, struct = nil}}

function TUidButtonLongScanner:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonLongScanner', self.UidButtonLongScanner, 'uint8', false, errs, need_convert)

    TUidButtonLongScanner:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonLongScanner.proto_property, errs, need_convert)
    return self
end

function TUidButtonLongScanner:unpack(_)
    return self.UidButtonLongScanner
end

MChassis.UidButtonLongScanner = TUidButtonLongScanner

---@class MChassis.UidButtonLongAccessor
---@field UidButtonLongAccessor integer
local TUidButtonLongAccessor = {}
TUidButtonLongAccessor.__index = TUidButtonLongAccessor
TUidButtonLongAccessor.group = {}

local function TUidButtonLongAccessor_from_obj(obj)
    return setmetatable(obj, TUidButtonLongAccessor)
end

function TUidButtonLongAccessor.new(UidButtonLongAccessor)
    return TUidButtonLongAccessor_from_obj({UidButtonLongAccessor = UidButtonLongAccessor})
end
---@param obj MChassis.UidButtonLongAccessor
function TUidButtonLongAccessor:init_from_obj(obj)
    self.UidButtonLongAccessor = obj.UidButtonLongAccessor
end

function TUidButtonLongAccessor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonLongAccessor.group)
end

TUidButtonLongAccessor.from_obj = TUidButtonLongAccessor_from_obj

TUidButtonLongAccessor.proto_property = {'UidButtonLongAccessor'}

TUidButtonLongAccessor.default = {0}

TUidButtonLongAccessor.struct = {{name = 'UidButtonLongAccessor', is_array = false, struct = nil}}

function TUidButtonLongAccessor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonLongAccessor', self.UidButtonLongAccessor, 'uint8', false, errs, need_convert)

    TUidButtonLongAccessor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonLongAccessor.proto_property, errs, need_convert)
    return self
end

function TUidButtonLongAccessor:unpack(_)
    return self.UidButtonLongAccessor
end

MChassis.UidButtonLongAccessor = TUidButtonLongAccessor

---@class MChassis.UidButtonScanner
---@field UidButtonScanner integer
local TUidButtonScanner = {}
TUidButtonScanner.__index = TUidButtonScanner
TUidButtonScanner.group = {}

local function TUidButtonScanner_from_obj(obj)
    return setmetatable(obj, TUidButtonScanner)
end

function TUidButtonScanner.new(UidButtonScanner)
    return TUidButtonScanner_from_obj({UidButtonScanner = UidButtonScanner})
end
---@param obj MChassis.UidButtonScanner
function TUidButtonScanner:init_from_obj(obj)
    self.UidButtonScanner = obj.UidButtonScanner
end

function TUidButtonScanner:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonScanner.group)
end

TUidButtonScanner.from_obj = TUidButtonScanner_from_obj

TUidButtonScanner.proto_property = {'UidButtonScanner'}

TUidButtonScanner.default = {0}

TUidButtonScanner.struct = {{name = 'UidButtonScanner', is_array = false, struct = nil}}

function TUidButtonScanner:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonScanner', self.UidButtonScanner, 'uint8', false, errs, need_convert)

    TUidButtonScanner:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonScanner.proto_property, errs, need_convert)
    return self
end

function TUidButtonScanner:unpack(_)
    return self.UidButtonScanner
end

MChassis.UidButtonScanner = TUidButtonScanner

---@class MChassis.UidButtonAccessor
---@field UidButtonAccessor integer
local TUidButtonAccessor = {}
TUidButtonAccessor.__index = TUidButtonAccessor
TUidButtonAccessor.group = {}

local function TUidButtonAccessor_from_obj(obj)
    return setmetatable(obj, TUidButtonAccessor)
end

function TUidButtonAccessor.new(UidButtonAccessor)
    return TUidButtonAccessor_from_obj({UidButtonAccessor = UidButtonAccessor})
end
---@param obj MChassis.UidButtonAccessor
function TUidButtonAccessor:init_from_obj(obj)
    self.UidButtonAccessor = obj.UidButtonAccessor
end

function TUidButtonAccessor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonAccessor.group)
end

TUidButtonAccessor.from_obj = TUidButtonAccessor_from_obj

TUidButtonAccessor.proto_property = {'UidButtonAccessor'}

TUidButtonAccessor.default = {0}

TUidButtonAccessor.struct = {{name = 'UidButtonAccessor', is_array = false, struct = nil}}

function TUidButtonAccessor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonAccessor', self.UidButtonAccessor, 'uint8', false, errs, need_convert)

    TUidButtonAccessor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonAccessor.proto_property, errs, need_convert)
    return self
end

function TUidButtonAccessor:unpack(_)
    return self.UidButtonAccessor
end

MChassis.UidButtonAccessor = TUidButtonAccessor

---@class MChassis.LastIntrusionACOn
---@field LastIntrusionACOn integer
local TLastIntrusionACOn = {}
TLastIntrusionACOn.__index = TLastIntrusionACOn
TLastIntrusionACOn.group = {}

local function TLastIntrusionACOn_from_obj(obj)
    return setmetatable(obj, TLastIntrusionACOn)
end

function TLastIntrusionACOn.new(LastIntrusionACOn)
    return TLastIntrusionACOn_from_obj({LastIntrusionACOn = LastIntrusionACOn or 0})
end
---@param obj MChassis.LastIntrusionACOn
function TLastIntrusionACOn:init_from_obj(obj)
    self.LastIntrusionACOn = obj.LastIntrusionACOn or 0
end

function TLastIntrusionACOn:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastIntrusionACOn.group)
end

TLastIntrusionACOn.from_obj = TLastIntrusionACOn_from_obj

TLastIntrusionACOn.proto_property = {'LastIntrusionACOn'}

TLastIntrusionACOn.default = {0}

TLastIntrusionACOn.struct = {{name = 'LastIntrusionACOn', is_array = false, struct = nil}}

function TLastIntrusionACOn:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastIntrusionACOn', self.LastIntrusionACOn, 'uint8', false, errs, need_convert)

    TLastIntrusionACOn:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastIntrusionACOn.proto_property, errs, need_convert)
    return self
end

function TLastIntrusionACOn:unpack(_)
    return self.LastIntrusionACOn
end

MChassis.LastIntrusionACOn = TLastIntrusionACOn

---@class MChassis.CoverStatus
---@field CoverStatus integer
local TCoverStatus = {}
TCoverStatus.__index = TCoverStatus
TCoverStatus.group = {}

local function TCoverStatus_from_obj(obj)
    return setmetatable(obj, TCoverStatus)
end

function TCoverStatus.new(CoverStatus)
    return TCoverStatus_from_obj({CoverStatus = CoverStatus})
end
---@param obj MChassis.CoverStatus
function TCoverStatus:init_from_obj(obj)
    self.CoverStatus = obj.CoverStatus
end

function TCoverStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCoverStatus.group)
end

TCoverStatus.from_obj = TCoverStatus_from_obj

TCoverStatus.proto_property = {'CoverStatus'}

TCoverStatus.default = {0}

TCoverStatus.struct = {{name = 'CoverStatus', is_array = false, struct = nil}}

function TCoverStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CoverStatus', self.CoverStatus, 'uint8', false, errs, need_convert)

    TCoverStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCoverStatus.proto_property, errs, need_convert)
    return self
end

function TCoverStatus:unpack(_)
    return self.CoverStatus
end

MChassis.CoverStatus = TCoverStatus

---@class MChassis.IntrusionACOffClear
---@field IntrusionACOffClear integer
local TIntrusionACOffClear = {}
TIntrusionACOffClear.__index = TIntrusionACOffClear
TIntrusionACOffClear.group = {}

local function TIntrusionACOffClear_from_obj(obj)
    return setmetatable(obj, TIntrusionACOffClear)
end

function TIntrusionACOffClear.new(IntrusionACOffClear)
    return TIntrusionACOffClear_from_obj({IntrusionACOffClear = IntrusionACOffClear})
end
---@param obj MChassis.IntrusionACOffClear
function TIntrusionACOffClear:init_from_obj(obj)
    self.IntrusionACOffClear = obj.IntrusionACOffClear
end

function TIntrusionACOffClear:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIntrusionACOffClear.group)
end

TIntrusionACOffClear.from_obj = TIntrusionACOffClear_from_obj

TIntrusionACOffClear.proto_property = {'IntrusionACOffClear'}

TIntrusionACOffClear.default = {0}

TIntrusionACOffClear.struct = {{name = 'IntrusionACOffClear', is_array = false, struct = nil}}

function TIntrusionACOffClear:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IntrusionACOffClear', self.IntrusionACOffClear, 'uint8', false, errs, need_convert)

    TIntrusionACOffClear:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIntrusionACOffClear.proto_property, errs, need_convert)
    return self
end

function TIntrusionACOffClear:unpack(_)
    return self.IntrusionACOffClear
end

MChassis.IntrusionACOffClear = TIntrusionACOffClear

---@class MChassis.IntrusionACOnClear
---@field IntrusionACOnClear integer
local TIntrusionACOnClear = {}
TIntrusionACOnClear.__index = TIntrusionACOnClear
TIntrusionACOnClear.group = {}

local function TIntrusionACOnClear_from_obj(obj)
    return setmetatable(obj, TIntrusionACOnClear)
end

function TIntrusionACOnClear.new(IntrusionACOnClear)
    return TIntrusionACOnClear_from_obj({IntrusionACOnClear = IntrusionACOnClear})
end
---@param obj MChassis.IntrusionACOnClear
function TIntrusionACOnClear:init_from_obj(obj)
    self.IntrusionACOnClear = obj.IntrusionACOnClear
end

function TIntrusionACOnClear:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIntrusionACOnClear.group)
end

TIntrusionACOnClear.from_obj = TIntrusionACOnClear_from_obj

TIntrusionACOnClear.proto_property = {'IntrusionACOnClear'}

TIntrusionACOnClear.default = {0}

TIntrusionACOnClear.struct = {{name = 'IntrusionACOnClear', is_array = false, struct = nil}}

function TIntrusionACOnClear:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IntrusionACOnClear', self.IntrusionACOnClear, 'uint8', false, errs, need_convert)

    TIntrusionACOnClear:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIntrusionACOnClear.proto_property, errs, need_convert)
    return self
end

function TIntrusionACOnClear:unpack(_)
    return self.IntrusionACOnClear
end

MChassis.IntrusionACOnClear = TIntrusionACOnClear

---@class MChassis.IntrusionACOff
---@field IntrusionACOff integer
local TIntrusionACOff = {}
TIntrusionACOff.__index = TIntrusionACOff
TIntrusionACOff.group = {}

local function TIntrusionACOff_from_obj(obj)
    return setmetatable(obj, TIntrusionACOff)
end

function TIntrusionACOff.new(IntrusionACOff)
    return TIntrusionACOff_from_obj({IntrusionACOff = IntrusionACOff})
end
---@param obj MChassis.IntrusionACOff
function TIntrusionACOff:init_from_obj(obj)
    self.IntrusionACOff = obj.IntrusionACOff
end

function TIntrusionACOff:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIntrusionACOff.group)
end

TIntrusionACOff.from_obj = TIntrusionACOff_from_obj

TIntrusionACOff.proto_property = {'IntrusionACOff'}

TIntrusionACOff.default = {0}

TIntrusionACOff.struct = {{name = 'IntrusionACOff', is_array = false, struct = nil}}

function TIntrusionACOff:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IntrusionACOff', self.IntrusionACOff, 'uint8', false, errs, need_convert)

    TIntrusionACOff:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIntrusionACOff.proto_property, errs, need_convert)
    return self
end

function TIntrusionACOff:unpack(_)
    return self.IntrusionACOff
end

MChassis.IntrusionACOff = TIntrusionACOff

---@class MChassis.IntrusionACOn
---@field IntrusionACOn integer
local TIntrusionACOn = {}
TIntrusionACOn.__index = TIntrusionACOn
TIntrusionACOn.group = {}

local function TIntrusionACOn_from_obj(obj)
    return setmetatable(obj, TIntrusionACOn)
end

function TIntrusionACOn.new(IntrusionACOn)
    return TIntrusionACOn_from_obj({IntrusionACOn = IntrusionACOn})
end
---@param obj MChassis.IntrusionACOn
function TIntrusionACOn:init_from_obj(obj)
    self.IntrusionACOn = obj.IntrusionACOn
end

function TIntrusionACOn:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIntrusionACOn.group)
end

TIntrusionACOn.from_obj = TIntrusionACOn_from_obj

TIntrusionACOn.proto_property = {'IntrusionACOn'}

TIntrusionACOn.default = {0}

TIntrusionACOn.struct = {{name = 'IntrusionACOn', is_array = false, struct = nil}}

function TIntrusionACOn:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IntrusionACOn', self.IntrusionACOn, 'uint8', false, errs, need_convert)

    TIntrusionACOn:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIntrusionACOn.proto_property, errs, need_convert)
    return self
end

function TIntrusionACOn:unpack(_)
    return self.IntrusionACOn
end

MChassis.IntrusionACOn = TIntrusionACOn

return MChassis
