-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Processor = {}

---@class Processor.Replaceable
---@field Replaceable boolean
local TReplaceable = {}
TReplaceable.__index = TReplaceable
TReplaceable.group = {}

local function TReplaceable_from_obj(obj)
    return setmetatable(obj, TReplaceable)
end

function TReplaceable.new(Replaceable)
    return TReplaceable_from_obj({Replaceable = Replaceable})
end
---@param obj Processor.Replaceable
function TReplaceable:init_from_obj(obj)
    self.Replaceable = obj.Replaceable
end

function TReplaceable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReplaceable.group)
end

TReplaceable.from_obj = TReplaceable_from_obj

TReplaceable.proto_property = {'Replaceable'}

TReplaceable.default = {false}

TReplaceable.struct = {{name = 'Replaceable', is_array = false, struct = nil}}

function TReplaceable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Replaceable', self.Replaceable, 'bool', true, errs, need_convert)

    TReplaceable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReplaceable.proto_property, errs, need_convert)
    return self
end

function TReplaceable:unpack(_)
    return self.Replaceable
end

Processor.Replaceable = TReplaceable

---@class Processor.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj Processor.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Processor.Health = THealth

---@class Processor.ThermalTrip
---@field ThermalTrip integer
local TThermalTrip = {}
TThermalTrip.__index = TThermalTrip
TThermalTrip.group = {}

local function TThermalTrip_from_obj(obj)
    return setmetatable(obj, TThermalTrip)
end

function TThermalTrip.new(ThermalTrip)
    return TThermalTrip_from_obj({ThermalTrip = ThermalTrip})
end
---@param obj Processor.ThermalTrip
function TThermalTrip:init_from_obj(obj)
    self.ThermalTrip = obj.ThermalTrip
end

function TThermalTrip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TThermalTrip.group)
end

TThermalTrip.from_obj = TThermalTrip_from_obj

TThermalTrip.proto_property = {'ThermalTrip'}

TThermalTrip.default = {0}

TThermalTrip.struct = {{name = 'ThermalTrip', is_array = false, struct = nil}}

function TThermalTrip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ThermalTrip', self.ThermalTrip, 'uint8', false, errs, need_convert)

    TThermalTrip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TThermalTrip.proto_property, errs, need_convert)
    return self
end

function TThermalTrip:unpack(_)
    return self.ThermalTrip
end

Processor.ThermalTrip = TThermalTrip

---@class Processor.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj Processor.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

Processor.Position = TPosition

---@class Processor.SocketDesignation
---@field SocketDesignation string
local TSocketDesignation = {}
TSocketDesignation.__index = TSocketDesignation
TSocketDesignation.group = {}

local function TSocketDesignation_from_obj(obj)
    return setmetatable(obj, TSocketDesignation)
end

function TSocketDesignation.new(SocketDesignation)
    return TSocketDesignation_from_obj({SocketDesignation = SocketDesignation})
end
---@param obj Processor.SocketDesignation
function TSocketDesignation:init_from_obj(obj)
    self.SocketDesignation = obj.SocketDesignation
end

function TSocketDesignation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketDesignation.group)
end

TSocketDesignation.from_obj = TSocketDesignation_from_obj

TSocketDesignation.proto_property = {'SocketDesignation'}

TSocketDesignation.default = {''}

TSocketDesignation.struct = {{name = 'SocketDesignation', is_array = false, struct = nil}}

function TSocketDesignation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketDesignation', self.SocketDesignation, 'string', true, errs, need_convert)

    TSocketDesignation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketDesignation.proto_property, errs, need_convert)
    return self
end

function TSocketDesignation:unpack(_)
    return self.SocketDesignation
end

Processor.SocketDesignation = TSocketDesignation

---@class Processor.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj Processor.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

Processor.FirmwareVersion = TFirmwareVersion

---@class Processor.SN
---@field SN string
local TSN = {}
TSN.__index = TSN
TSN.group = {}

local function TSN_from_obj(obj)
    return setmetatable(obj, TSN)
end

function TSN.new(SN)
    return TSN_from_obj({SN = SN})
end
---@param obj Processor.SN
function TSN:init_from_obj(obj)
    self.SN = obj.SN
end

function TSN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSN.group)
end

TSN.from_obj = TSN_from_obj

TSN.proto_property = {'SN'}

TSN.default = {''}

TSN.struct = {{name = 'SN', is_array = false, struct = nil}}

function TSN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SN', self.SN, 'string', true, errs, need_convert)

    TSN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSN.proto_property, errs, need_convert)
    return self
end

function TSN:unpack(_)
    return self.SN
end

Processor.SN = TSN

---@class Processor.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Processor.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Processor.PartNumber = TPartNumber

---@class Processor.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj Processor.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

Processor.Model = TModel

---@class Processor.Family
---@field Family string
local TFamily = {}
TFamily.__index = TFamily
TFamily.group = {}

local function TFamily_from_obj(obj)
    return setmetatable(obj, TFamily)
end

function TFamily.new(Family)
    return TFamily_from_obj({Family = Family})
end
---@param obj Processor.Family
function TFamily:init_from_obj(obj)
    self.Family = obj.Family
end

function TFamily:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFamily.group)
end

TFamily.from_obj = TFamily_from_obj

TFamily.proto_property = {'Family'}

TFamily.default = {''}

TFamily.struct = {{name = 'Family', is_array = false, struct = nil}}

function TFamily:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Family', self.Family, 'string', true, errs, need_convert)

    TFamily:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFamily.proto_property, errs, need_convert)
    return self
end

function TFamily:unpack(_)
    return self.Family
end

Processor.Family = TFamily

---@class Processor.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Processor.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Processor.Manufacturer = TManufacturer

---@class Processor.Architecture
---@field Architecture string
local TArchitecture = {}
TArchitecture.__index = TArchitecture
TArchitecture.group = {}

local function TArchitecture_from_obj(obj)
    return setmetatable(obj, TArchitecture)
end

function TArchitecture.new(Architecture)
    return TArchitecture_from_obj({Architecture = Architecture})
end
---@param obj Processor.Architecture
function TArchitecture:init_from_obj(obj)
    self.Architecture = obj.Architecture
end

function TArchitecture:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TArchitecture.group)
end

TArchitecture.from_obj = TArchitecture_from_obj

TArchitecture.proto_property = {'Architecture'}

TArchitecture.default = {''}

TArchitecture.struct = {{name = 'Architecture', is_array = false, struct = nil}}

function TArchitecture:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Architecture', self.Architecture, 'string', true, errs, need_convert)

    TArchitecture:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TArchitecture.proto_property, errs, need_convert)
    return self
end

function TArchitecture:unpack(_)
    return self.Architecture
end

Processor.Architecture = TArchitecture

---@class Processor.InstructionSet
---@field InstructionSet string
local TInstructionSet = {}
TInstructionSet.__index = TInstructionSet
TInstructionSet.group = {}

local function TInstructionSet_from_obj(obj)
    return setmetatable(obj, TInstructionSet)
end

function TInstructionSet.new(InstructionSet)
    return TInstructionSet_from_obj({InstructionSet = InstructionSet})
end
---@param obj Processor.InstructionSet
function TInstructionSet:init_from_obj(obj)
    self.InstructionSet = obj.InstructionSet
end

function TInstructionSet:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInstructionSet.group)
end

TInstructionSet.from_obj = TInstructionSet_from_obj

TInstructionSet.proto_property = {'InstructionSet'}

TInstructionSet.default = {''}

TInstructionSet.struct = {{name = 'InstructionSet', is_array = false, struct = nil}}

function TInstructionSet:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InstructionSet', self.InstructionSet, 'string', true, errs, need_convert)

    TInstructionSet:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInstructionSet.proto_property, errs, need_convert)
    return self
end

function TInstructionSet:unpack(_)
    return self.InstructionSet
end

Processor.InstructionSet = TInstructionSet

---@class Processor.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Processor.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Processor.Presence = TPresence

---@class Processor.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Processor.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Processor.Name = TName

---@class Processor.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Processor.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Processor.Id = TId

---@class Processor.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj Processor.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

Processor.SystemId = TSystemId

---@class Processor.ProcessorType
---@field ProcessorType string
local TProcessorType = {}
TProcessorType.__index = TProcessorType
TProcessorType.group = {}

local function TProcessorType_from_obj(obj)
    return setmetatable(obj, TProcessorType)
end

function TProcessorType.new(ProcessorType)
    return TProcessorType_from_obj({ProcessorType = ProcessorType})
end
---@param obj Processor.ProcessorType
function TProcessorType:init_from_obj(obj)
    self.ProcessorType = obj.ProcessorType
end

function TProcessorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessorType.group)
end

TProcessorType.from_obj = TProcessorType_from_obj

TProcessorType.proto_property = {'ProcessorType'}

TProcessorType.default = {''}

TProcessorType.struct = {{name = 'ProcessorType', is_array = false, struct = nil}}

function TProcessorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessorType', self.ProcessorType, 'string', true, errs, need_convert)

    TProcessorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessorType.proto_property, errs, need_convert)
    return self
end

function TProcessorType:unpack(_)
    return self.ProcessorType
end

Processor.ProcessorType = TProcessorType

Processor.interface = mdb.register_interface('bmc.kepler.Systems.Processor', {
    ProcessorType = {'s', nil, true, nil, false},
    SystemId = {'y', nil, true, nil, false},
    Id = {'y', nil, true, nil, false},
    Name = {'s', nil, true, nil, false},
    Presence = {'y', nil, true, nil, false},
    InstructionSet = {'s', nil, true, nil, false},
    Architecture = {'s', nil, true, nil, false},
    Manufacturer = {'s', nil, true, nil, false},
    Family = {'s', {}, true, nil, false},
    Model = {'s', nil, true, nil, false},
    PartNumber = {'s', nil, true, nil, false},
    SN = {'s', nil, true, nil, false},
    FirmwareVersion = {'s', nil, true, nil, false},
    SocketDesignation = {'s', nil, true, nil, false},
    Position = {'s', nil, true, nil, false},
    ThermalTrip = {'y', nil, false, nil, false},
    Health = {'y', nil, true, nil, false},
    Replaceable = {'b', {}, true, nil, false}
}, {}, {})

return Processor
