-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Policy = {}

---@class Policy.Critical
---@field Critical integer[]
local TCritical = {}
TCritical.__index = TCritical
TCritical.group = {}

local function TCritical_from_obj(obj)
    return setmetatable(obj, TCritical)
end

function TCritical.new(Critical)
    return TCritical_from_obj({Critical = Critical})
end
---@param obj Policy.Critical
function TCritical:init_from_obj(obj)
    self.Critical = obj.Critical
end

function TCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCritical.group)
end

TCritical.from_obj = TCritical_from_obj

TCritical.proto_property = {'Critical'}

TCritical.default = {{}}

TCritical.struct = {{name = 'Critical', is_array = true, struct = nil}}

function TCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Critical', self.Critical, 'uint16', false, errs, need_convert)

    TCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCritical.proto_property, errs, need_convert)
    return self
end

function TCritical:unpack(_)
    return self.Critical
end

Policy.Critical = TCritical

---@class Policy.Major
---@field Major integer[]
local TMajor = {}
TMajor.__index = TMajor
TMajor.group = {}

local function TMajor_from_obj(obj)
    return setmetatable(obj, TMajor)
end

function TMajor.new(Major)
    return TMajor_from_obj({Major = Major})
end
---@param obj Policy.Major
function TMajor:init_from_obj(obj)
    self.Major = obj.Major
end

function TMajor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMajor.group)
end

TMajor.from_obj = TMajor_from_obj

TMajor.proto_property = {'Major'}

TMajor.default = {{}}

TMajor.struct = {{name = 'Major', is_array = true, struct = nil}}

function TMajor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Major', self.Major, 'uint16', false, errs, need_convert)

    TMajor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMajor.proto_property, errs, need_convert)
    return self
end

function TMajor:unpack(_)
    return self.Major
end

Policy.Major = TMajor

---@class Policy.Minor
---@field Minor integer[]
local TMinor = {}
TMinor.__index = TMinor
TMinor.group = {}

local function TMinor_from_obj(obj)
    return setmetatable(obj, TMinor)
end

function TMinor.new(Minor)
    return TMinor_from_obj({Minor = Minor})
end
---@param obj Policy.Minor
function TMinor:init_from_obj(obj)
    self.Minor = obj.Minor
end

function TMinor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinor.group)
end

TMinor.from_obj = TMinor_from_obj

TMinor.proto_property = {'Minor'}

TMinor.default = {{}}

TMinor.struct = {{name = 'Minor', is_array = true, struct = nil}}

function TMinor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Minor', self.Minor, 'uint16', false, errs, need_convert)

    TMinor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinor.proto_property, errs, need_convert)
    return self
end

function TMinor:unpack(_)
    return self.Minor
end

Policy.Minor = TMinor

---@class Policy.Normal
---@field Normal integer[]
local TNormal = {}
TNormal.__index = TNormal
TNormal.group = {}

local function TNormal_from_obj(obj)
    return setmetatable(obj, TNormal)
end

function TNormal.new(Normal)
    return TNormal_from_obj({Normal = Normal})
end
---@param obj Policy.Normal
function TNormal:init_from_obj(obj)
    self.Normal = obj.Normal
end

function TNormal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNormal.group)
end

TNormal.from_obj = TNormal_from_obj

TNormal.proto_property = {'Normal'}

TNormal.default = {{}}

TNormal.struct = {{name = 'Normal', is_array = true, struct = nil}}

function TNormal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Normal', self.Normal, 'uint16', false, errs, need_convert)

    TNormal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNormal.proto_property, errs, need_convert)
    return self
end

function TNormal:unpack(_)
    return self.Normal
end

Policy.Normal = TNormal

Policy.interface = mdb.register_interface('bmc.kepler.Systems.Led.Policy', {
    Normal = {'aq', {}, false, nil, false},
    Minor = {'aq', {}, false, nil, false},
    Major = {'aq', {}, false, nil, false},
    Critical = {'aq', {}, false, nil, false}
}, {}, {})

return Policy
