-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Enclosure = {}

---@class Enclosure.EnclosureSerialNumber
---@field EnclosureSerialNumber string
local TEnclosureSerialNumber = {}
TEnclosureSerialNumber.__index = TEnclosureSerialNumber
TEnclosureSerialNumber.group = {}

local function TEnclosureSerialNumber_from_obj(obj)
    return setmetatable(obj, TEnclosureSerialNumber)
end

function TEnclosureSerialNumber.new(EnclosureSerialNumber)
    return TEnclosureSerialNumber_from_obj({EnclosureSerialNumber = EnclosureSerialNumber})
end
---@param obj Enclosure.EnclosureSerialNumber
function TEnclosureSerialNumber:init_from_obj(obj)
    self.EnclosureSerialNumber = obj.EnclosureSerialNumber
end

function TEnclosureSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnclosureSerialNumber.group)
end

TEnclosureSerialNumber.from_obj = TEnclosureSerialNumber_from_obj

TEnclosureSerialNumber.proto_property = {'EnclosureSerialNumber'}

TEnclosureSerialNumber.default = {''}

TEnclosureSerialNumber.struct = {{name = 'EnclosureSerialNumber', is_array = false, struct = nil}}

function TEnclosureSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnclosureSerialNumber', self.EnclosureSerialNumber, 'string', true, errs, need_convert)

    TEnclosureSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnclosureSerialNumber.proto_property, errs, need_convert)
    return self
end

function TEnclosureSerialNumber:unpack(_)
    return self.EnclosureSerialNumber
end

Enclosure.EnclosureSerialNumber = TEnclosureSerialNumber

---@class Enclosure.CabinetSerialNumber
---@field CabinetSerialNumber string
local TCabinetSerialNumber = {}
TCabinetSerialNumber.__index = TCabinetSerialNumber
TCabinetSerialNumber.group = {}

local function TCabinetSerialNumber_from_obj(obj)
    return setmetatable(obj, TCabinetSerialNumber)
end

function TCabinetSerialNumber.new(CabinetSerialNumber)
    return TCabinetSerialNumber_from_obj({CabinetSerialNumber = CabinetSerialNumber})
end
---@param obj Enclosure.CabinetSerialNumber
function TCabinetSerialNumber:init_from_obj(obj)
    self.CabinetSerialNumber = obj.CabinetSerialNumber
end

function TCabinetSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCabinetSerialNumber.group)
end

TCabinetSerialNumber.from_obj = TCabinetSerialNumber_from_obj

TCabinetSerialNumber.proto_property = {'CabinetSerialNumber'}

TCabinetSerialNumber.default = {''}

TCabinetSerialNumber.struct = {{name = 'CabinetSerialNumber', is_array = false, struct = nil}}

function TCabinetSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CabinetSerialNumber', self.CabinetSerialNumber, 'string', true, errs, need_convert)

    TCabinetSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCabinetSerialNumber.proto_property, errs, need_convert)
    return self
end

function TCabinetSerialNumber:unpack(_)
    return self.CabinetSerialNumber
end

Enclosure.CabinetSerialNumber = TCabinetSerialNumber

Enclosure.interface = mdb.register_interface('bmc.kepler.Chassis.Enclosure', {
    CabinetSerialNumber = {'s', {}, true, nil, false},
    EnclosureSerialNumber = {'s', {}, true, nil, false}
}, {}, {})

return Enclosure
