--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSuperPodId = {}

---@class ChassisIpmiCmds.SetSuperPodIdReq
---@field ManufactureId integer
---@field Reserved integer
---@field Data integer[]
local TSetSuperPodIdReq = {}
TSetSuperPodIdReq.__index = TSetSuperPodIdReq
TSetSuperPodIdReq.group = {}

local function TSetSuperPodIdReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodIdReq)
end

function TSetSuperPodIdReq.new(ManufactureId, Reserved, Data)
    return TSetSuperPodIdReq_from_obj({ManufactureId = ManufactureId, Reserved = Reserved, Data = Data})
end
---@param obj ChassisIpmiCmds.SetSuperPodIdReq
function TSetSuperPodIdReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TSetSuperPodIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodIdReq.group)
end

TSetSuperPodIdReq.from_obj = TSetSuperPodIdReq_from_obj

TSetSuperPodIdReq.proto_property = {'ManufactureId', 'Reserved', 'Data'}

TSetSuperPodIdReq.default = {0, 0, {}}

TSetSuperPodIdReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TSetSuperPodIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 4, 4, errs, need_convert)
    end

    TSetSuperPodIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodIdReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodIdReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.Data
end

SetSuperPodId.SetSuperPodIdReq = TSetSuperPodIdReq

---@class ChassisIpmiCmds.SetSuperPodIdRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSuperPodIdRsp = {}
TSetSuperPodIdRsp.__index = TSetSuperPodIdRsp
TSetSuperPodIdRsp.group = {}

local function TSetSuperPodIdRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodIdRsp)
end

function TSetSuperPodIdRsp.new(CompletionCode, ManufactureId)
    return TSetSuperPodIdRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.SetSuperPodIdRsp
function TSetSuperPodIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSuperPodIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodIdRsp.group)
end

TSetSuperPodIdRsp.from_obj = TSetSuperPodIdRsp_from_obj

TSetSuperPodIdRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSuperPodIdRsp.default = {0, 0}

TSetSuperPodIdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSuperPodIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSuperPodIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodIdRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodIdRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSuperPodId.SetSuperPodIdRsp = TSetSuperPodIdRsp

return SetSuperPodId
