--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetServerIndex = {}

---@class ChassisIpmiCmds.SetServerIndexReq
---@field ManufactureId integer
---@field Reserved integer
---@field Data integer[]
local TSetServerIndexReq = {}
TSetServerIndexReq.__index = TSetServerIndexReq
TSetServerIndexReq.group = {}

local function TSetServerIndexReq_from_obj(obj)
    return setmetatable(obj, TSetServerIndexReq)
end

function TSetServerIndexReq.new(ManufactureId, Reserved, Data)
    return TSetServerIndexReq_from_obj({ManufactureId = ManufactureId, Reserved = Reserved, Data = Data})
end
---@param obj ChassisIpmiCmds.SetServerIndexReq
function TSetServerIndexReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TSetServerIndexReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetServerIndexReq.group)
end

TSetServerIndexReq.from_obj = TSetServerIndexReq_from_obj

TSetServerIndexReq.proto_property = {'ManufactureId', 'Reserved', 'Data'}

TSetServerIndexReq.default = {0, 0, {}}

TSetServerIndexReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TSetServerIndexReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 2, 2, errs, need_convert)
    end

    TSetServerIndexReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetServerIndexReq.proto_property, errs, need_convert)
    return self
end

function TSetServerIndexReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.Data
end

SetServerIndex.SetServerIndexReq = TSetServerIndexReq

---@class ChassisIpmiCmds.SetServerIndexRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetServerIndexRsp = {}
TSetServerIndexRsp.__index = TSetServerIndexRsp
TSetServerIndexRsp.group = {}

local function TSetServerIndexRsp_from_obj(obj)
    return setmetatable(obj, TSetServerIndexRsp)
end

function TSetServerIndexRsp.new(CompletionCode, ManufactureId)
    return TSetServerIndexRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.SetServerIndexRsp
function TSetServerIndexRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetServerIndexRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetServerIndexRsp.group)
end

TSetServerIndexRsp.from_obj = TSetServerIndexRsp_from_obj

TSetServerIndexRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetServerIndexRsp.default = {0, 0}

TSetServerIndexRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetServerIndexRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetServerIndexRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetServerIndexRsp.proto_property, errs, need_convert)
    return self
end

function TSetServerIndexRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetServerIndex.SetServerIndexRsp = TSetServerIndexRsp

return SetServerIndex
