--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDeviceCapabilities = {}

---@class ChassisIpmiCmds.SetDeviceCapabilitiesReq
---@field ManufactureId integer
---@field InfoNum integer
---@field MsgLen integer
---@field Capabilities string
local TSetDeviceCapabilitiesReq = {}
TSetDeviceCapabilitiesReq.__index = TSetDeviceCapabilitiesReq
TSetDeviceCapabilitiesReq.group = {}

local function TSetDeviceCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TSetDeviceCapabilitiesReq)
end

function TSetDeviceCapabilitiesReq.new(ManufactureId, InfoNum, MsgLen, Capabilities)
    return TSetDeviceCapabilitiesReq_from_obj({
        ManufactureId = ManufactureId,
        InfoNum = InfoNum,
        MsgLen = MsgLen,
        Capabilities = Capabilities
    })
end
---@param obj ChassisIpmiCmds.SetDeviceCapabilitiesReq
function TSetDeviceCapabilitiesReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.InfoNum = obj.InfoNum
    self.MsgLen = obj.MsgLen
    self.Capabilities = obj.Capabilities
end

function TSetDeviceCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDeviceCapabilitiesReq.group)
end

TSetDeviceCapabilitiesReq.from_obj = TSetDeviceCapabilitiesReq_from_obj

TSetDeviceCapabilitiesReq.proto_property = {'ManufactureId', 'InfoNum', 'MsgLen', 'Capabilities'}

TSetDeviceCapabilitiesReq.default = {0, 0, 0, ''}

TSetDeviceCapabilitiesReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'InfoNum', is_array = false, struct = nil},
    {name = 'MsgLen', is_array = false, struct = nil}, {name = 'Capabilities', is_array = false, struct = nil}
}

function TSetDeviceCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'InfoNum', self.InfoNum, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MsgLen', self.MsgLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Capabilities', self.Capabilities, 'string', false, errs, need_convert)

    TSetDeviceCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDeviceCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TSetDeviceCapabilitiesReq:unpack(_)
    return self.ManufactureId, self.InfoNum, self.MsgLen, self.Capabilities
end

SetDeviceCapabilities.SetDeviceCapabilitiesReq = TSetDeviceCapabilitiesReq

---@class ChassisIpmiCmds.SetDeviceCapabilitiesRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDeviceCapabilitiesRsp = {}
TSetDeviceCapabilitiesRsp.__index = TSetDeviceCapabilitiesRsp
TSetDeviceCapabilitiesRsp.group = {}

local function TSetDeviceCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TSetDeviceCapabilitiesRsp)
end

function TSetDeviceCapabilitiesRsp.new(CompletionCode, ManufactureId)
    return TSetDeviceCapabilitiesRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.SetDeviceCapabilitiesRsp
function TSetDeviceCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDeviceCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDeviceCapabilitiesRsp.group)
end

TSetDeviceCapabilitiesRsp.from_obj = TSetDeviceCapabilitiesRsp_from_obj

TSetDeviceCapabilitiesRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDeviceCapabilitiesRsp.default = {0, 0}

TSetDeviceCapabilitiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDeviceCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDeviceCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDeviceCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TSetDeviceCapabilitiesRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDeviceCapabilities.SetDeviceCapabilitiesRsp = TSetDeviceCapabilitiesRsp

return SetDeviceCapabilities
