--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSuperPodLabelInfo = {}

---@class ChassisIpmiCmds.GetSuperPodLabelInfoReq
---@field ManufactureId integer
local TGetSuperPodLabelInfoReq = {}
TGetSuperPodLabelInfoReq.__index = TGetSuperPodLabelInfoReq
TGetSuperPodLabelInfoReq.group = {}

local function TGetSuperPodLabelInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSuperPodLabelInfoReq)
end

function TGetSuperPodLabelInfoReq.new(ManufactureId)
    return TGetSuperPodLabelInfoReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.GetSuperPodLabelInfoReq
function TGetSuperPodLabelInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetSuperPodLabelInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSuperPodLabelInfoReq.group)
end

TGetSuperPodLabelInfoReq.from_obj = TGetSuperPodLabelInfoReq_from_obj

TGetSuperPodLabelInfoReq.proto_property = {'ManufactureId'}

TGetSuperPodLabelInfoReq.default = {0}

TGetSuperPodLabelInfoReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetSuperPodLabelInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetSuperPodLabelInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSuperPodLabelInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSuperPodLabelInfoReq:unpack(_)
    return self.ManufactureId
end

GetSuperPodLabelInfo.GetSuperPodLabelInfoReq = TGetSuperPodLabelInfoReq

---@class ChassisIpmiCmds.GetSuperPodLabelInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndFlag integer
---@field Data integer[]
local TGetSuperPodLabelInfoRsp = {}
TGetSuperPodLabelInfoRsp.__index = TGetSuperPodLabelInfoRsp
TGetSuperPodLabelInfoRsp.group = {}

local function TGetSuperPodLabelInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSuperPodLabelInfoRsp)
end

function TGetSuperPodLabelInfoRsp.new(CompletionCode, ManufactureId, EndFlag, Data)
    return TGetSuperPodLabelInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndFlag = EndFlag,
        Data = Data
    })
end
---@param obj ChassisIpmiCmds.GetSuperPodLabelInfoRsp
function TGetSuperPodLabelInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndFlag = obj.EndFlag
    self.Data = obj.Data
end

function TGetSuperPodLabelInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSuperPodLabelInfoRsp.group)
end

TGetSuperPodLabelInfoRsp.from_obj = TGetSuperPodLabelInfoRsp_from_obj

TGetSuperPodLabelInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndFlag', 'Data'}

TGetSuperPodLabelInfoRsp.default = {0, 0, 0, {}}

TGetSuperPodLabelInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndFlag', is_array = false, struct = nil}, {name = 'Data', is_array = true, struct = nil}
}

function TGetSuperPodLabelInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndFlag', self.EndFlag, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    TGetSuperPodLabelInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSuperPodLabelInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSuperPodLabelInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndFlag, self.Data
end

GetSuperPodLabelInfo.GetSuperPodLabelInfoRsp = TGetSuperPodLabelInfoRsp

return GetSuperPodLabelInfo
