--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLedColorCapabilities = {}

---@class ChassisIpmiCmds.GetLedColorCapabilitiesReq
---@field PicmgId integer
---@field FruId integer
---@field LedId integer
local TGetLedColorCapabilitiesReq = {}
TGetLedColorCapabilitiesReq.__index = TGetLedColorCapabilitiesReq
TGetLedColorCapabilitiesReq.group = {}

local function TGetLedColorCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TGetLedColorCapabilitiesReq)
end

function TGetLedColorCapabilitiesReq.new(PicmgId, FruId, LedId)
    return TGetLedColorCapabilitiesReq_from_obj({PicmgId = PicmgId, FruId = FruId, LedId = LedId})
end
---@param obj ChassisIpmiCmds.GetLedColorCapabilitiesReq
function TGetLedColorCapabilitiesReq:init_from_obj(obj)
    self.PicmgId = obj.PicmgId
    self.FruId = obj.FruId
    self.LedId = obj.LedId
end

function TGetLedColorCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLedColorCapabilitiesReq.group)
end

TGetLedColorCapabilitiesReq.from_obj = TGetLedColorCapabilitiesReq_from_obj

TGetLedColorCapabilitiesReq.proto_property = {'PicmgId', 'FruId', 'LedId'}

TGetLedColorCapabilitiesReq.default = {0, 0, 0}

TGetLedColorCapabilitiesReq.struct = {
    {name = 'PicmgId', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil},
    {name = 'LedId', is_array = false, struct = nil}
}

function TGetLedColorCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PicmgId', self.PicmgId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LedId', self.LedId, 'uint8', false, errs, need_convert)

    TGetLedColorCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLedColorCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TGetLedColorCapabilitiesReq:unpack(_)
    return self.PicmgId, self.FruId, self.LedId
end

GetLedColorCapabilities.GetLedColorCapabilitiesReq = TGetLedColorCapabilitiesReq

---@class ChassisIpmiCmds.GetLedColorCapabilitiesRsp
---@field CompletionCode integer
---@field PicmgId integer
---@field ColorCapabilities integer
---@field DefaultLCSColor integer
---@field DefaultOSColor integer
local TGetLedColorCapabilitiesRsp = {}
TGetLedColorCapabilitiesRsp.__index = TGetLedColorCapabilitiesRsp
TGetLedColorCapabilitiesRsp.group = {}

local function TGetLedColorCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TGetLedColorCapabilitiesRsp)
end

function TGetLedColorCapabilitiesRsp.new(CompletionCode, PicmgId, ColorCapabilities, DefaultLCSColor, DefaultOSColor)
    return TGetLedColorCapabilitiesRsp_from_obj({
        CompletionCode = CompletionCode,
        PicmgId = PicmgId,
        ColorCapabilities = ColorCapabilities,
        DefaultLCSColor = DefaultLCSColor,
        DefaultOSColor = DefaultOSColor
    })
end
---@param obj ChassisIpmiCmds.GetLedColorCapabilitiesRsp
function TGetLedColorCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgId = obj.PicmgId
    self.ColorCapabilities = obj.ColorCapabilities
    self.DefaultLCSColor = obj.DefaultLCSColor
    self.DefaultOSColor = obj.DefaultOSColor
end

function TGetLedColorCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLedColorCapabilitiesRsp.group)
end

TGetLedColorCapabilitiesRsp.from_obj = TGetLedColorCapabilitiesRsp_from_obj

TGetLedColorCapabilitiesRsp.proto_property = {
    'CompletionCode', 'PicmgId', 'ColorCapabilities', 'DefaultLCSColor', 'DefaultOSColor'
}

TGetLedColorCapabilitiesRsp.default = {0, 0, 0, 0, 0}

TGetLedColorCapabilitiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PicmgId', is_array = false, struct = nil},
    {name = 'ColorCapabilities', is_array = false, struct = nil},
    {name = 'DefaultLCSColor', is_array = false, struct = nil},
    {name = 'DefaultOSColor', is_array = false, struct = nil}
}

function TGetLedColorCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgId', self.PicmgId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ColorCapabilities', self.ColorCapabilities, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DefaultLCSColor', self.DefaultLCSColor, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DefaultOSColor', self.DefaultOSColor, 'uint8', false, errs, need_convert)

    TGetLedColorCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLedColorCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TGetLedColorCapabilitiesRsp:unpack(_)
    return self.CompletionCode, self.PicmgId, self.ColorCapabilities, self.DefaultLCSColor, self.DefaultOSColor
end

GetLedColorCapabilities.GetLedColorCapabilitiesRsp = TGetLedColorCapabilitiesRsp

return GetLedColorCapabilities
