--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetChassisHeight = {}

---@class ChassisIpmiCmds.GetChassisHeightReq
---@field ManufactureId integer
---@field ReadOffset integer
---@field ReadLen integer
local TGetChassisHeightReq = {}
TGetChassisHeightReq.__index = TGetChassisHeightReq
TGetChassisHeightReq.group = {}

local function TGetChassisHeightReq_from_obj(obj)
    return setmetatable(obj, TGetChassisHeightReq)
end

function TGetChassisHeightReq.new(ManufactureId, ReadOffset, ReadLen)
    return TGetChassisHeightReq_from_obj({ManufactureId = ManufactureId, ReadOffset = ReadOffset, ReadLen = ReadLen})
end
---@param obj ChassisIpmiCmds.GetChassisHeightReq
function TGetChassisHeightReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ReadOffset = obj.ReadOffset
    self.ReadLen = obj.ReadLen
end

function TGetChassisHeightReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChassisHeightReq.group)
end

TGetChassisHeightReq.from_obj = TGetChassisHeightReq_from_obj

TGetChassisHeightReq.proto_property = {'ManufactureId', 'ReadOffset', 'ReadLen'}

TGetChassisHeightReq.default = {0, 0, 0}

TGetChassisHeightReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'ReadLen', is_array = false, struct = nil}
}

function TGetChassisHeightReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLen', self.ReadLen, 'uint8', false, errs, need_convert)

    TGetChassisHeightReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChassisHeightReq.proto_property, errs, need_convert)
    return self
end

function TGetChassisHeightReq:unpack(_)
    return self.ManufactureId, self.ReadOffset, self.ReadLen
end

GetChassisHeight.GetChassisHeightReq = TGetChassisHeightReq

---@class ChassisIpmiCmds.GetChassisHeightRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndFlag integer
---@field Data string
local TGetChassisHeightRsp = {}
TGetChassisHeightRsp.__index = TGetChassisHeightRsp
TGetChassisHeightRsp.group = {}

local function TGetChassisHeightRsp_from_obj(obj)
    return setmetatable(obj, TGetChassisHeightRsp)
end

function TGetChassisHeightRsp.new(CompletionCode, ManufactureId, EndFlag, Data)
    return TGetChassisHeightRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndFlag = EndFlag,
        Data = Data
    })
end
---@param obj ChassisIpmiCmds.GetChassisHeightRsp
function TGetChassisHeightRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndFlag = obj.EndFlag
    self.Data = obj.Data
end

function TGetChassisHeightRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChassisHeightRsp.group)
end

TGetChassisHeightRsp.from_obj = TGetChassisHeightRsp_from_obj

TGetChassisHeightRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndFlag', 'Data'}

TGetChassisHeightRsp.default = {0, 0, 0, ''}

TGetChassisHeightRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndFlag', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetChassisHeightRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndFlag', self.EndFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetChassisHeightRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChassisHeightRsp.proto_property, errs, need_convert)
    return self
end

function TGetChassisHeightRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndFlag, self.Data
end

GetChassisHeight.GetChassisHeightRsp = TGetChassisHeightRsp

return GetChassisHeight
