-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local bios_factory = require 'factory.bios_factory'
local bios_fw_signal = require 'interface.signal'
local client = require 'bios.client'

TestSignal = {}

function TestSignal:test_not_support_parallel_upgrade()
    local get_service = bios_factory.get_service
    bios_factory.get_service = function ()
        return {
            dft_mode = true
        }
    end
    local ctx = {}
    local system_id = 1
    local firmware_type = 'Bios'
    local cfg_path = ''
    local hpm_path = ''
    local parameters = {
        UpgradeMode = 'Parallel'
    }
    local UpdateServiceUpdateServicePrepareReply = client.UpdateServiceUpdateServicePrepareReply
    client.UpdateServiceUpdateServicePrepareReply = function ()
        return true
    end
    local ok = bios_fw_signal.upgrade_prepare_callback(ctx, system_id, firmware_type, cfg_path, hpm_path, parameters)
    lu.assertEquals(ok, nil)
    bios_factory.get_service = get_service
    bios_factory.UpdateServiceUpdateServicePrepareReply = UpdateServiceUpdateServicePrepareReply
end