-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_service = require 'service.bios_service'
local lu = require 'luaunit'
local log = require 'mc.logging'
local json =require 'cjson'

TestUniversalInterface = {}

local file_data = {
    ["BootTypeOrder0"] = "DVDROMDrive",
    ["BootTypeOrder1"] = "HardDiskDrive",
    ["BootTypeOrder2"] = "PXE",
    ["BootTypeOrder3"] = "Others",
    ["bool"] = "false",
    ["num"] = "1"
}

function TestUniversalInterface:test_parses_file()
    --[[
        "BootTypeOrder0":"DVDROMDrive",
        "BootTypeOrder1":"HardDiskDrive",
        "BootTypeOrder2":"PXE",
        "BootTypeOrder3":"Others",
        "bool":"false",
        "num":"1"
    --]]
    --硬编码实现 currentvalue.json文件  存放在在指定目录下
    local f = io.open("currentvalue.json", "w+")
    local file_encode_data = json.encode(file_data)
    f:write(file_encode_data)
    f:close()
    os.execute('rm -rf currentvalue.json')
end