-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local client = require 'bios.client'
local lu = require 'luaunit'
local bs_util = require 'util.base_util'
local poweron_delay = require 'pojo.boot.poweron_delay'

Test_poweron_delay = {}

function Test_poweron_delay:test_get_info()
    local temp_restore = {
        GetDelayedPowerOnPolicyObjects = client.GetDelayedPowerOnPolicyObjects,
        get_obj_id = bs_util.get_obj_id
    }
    client.GetDelayedPowerOnPolicyObjects = function()
        -- 打桩资源树对象
        return {{Mode = "HalfDelay", path = "/bmc/kepler/Systems/1", Seconds = 50}}
    end
    bs_util.get_obj_id = function(path)
        return tonumber(string.match(path, 'bmc/kepler/Systems/(%d+)'))
    end
    local config_data = '\x00\x00'
    local _, rsp = pcall(function()
        return poweron_delay:get_info(config_data, 1)
    end)
    lu.assertEquals(rsp[3], 0x1)
    lu.assertEquals(rsp[4], 0xf4)
    lu.assertEquals(rsp[5], 0x1)
    lu.assertEquals(rsp[6], 0x0)
    lu.assertEquals(rsp[7], 0x0)
    client.GetDelayedPowerOnPolicyObjects = temp_restore.GetDelayedPowerOnPolicyObjects
    bs_util.get_obj_id = temp_restore.get_obj_id
end