-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_service = require 'service.bios_service'
local lu = require 'luaunit'

local open_db = require 'bios.db'
local test_common = require 'test_common.utils'
local bus = test_common.dbus_launch('../.dbus', nil, true)

TestMemorySilk = {}

local function construct_db()
    local ok, datas = pcall(require, 'bios.datas')
    if not ok then
        -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
        datas = nil
    end
    local db = open_db(':memory:', datas)
    return db
end

function TestMemorySilk:test_mem_cache_collection()
    local bios_ser = bios_service.get_instance(bus, construct_db())
    local mem_silk_objs = {'mem_silk_obj'}

    local ok = pcall(function ()
        bios_ser:add_mem_silk_from_cache(1)
    end)
    lu.assertEquals(ok, true)

    ok = pcall(function ()
        bios_ser:cache_mem_silk(1, mem_silk_objs)
    end)

    lu.assertEquals(ok, true)

    local objs = bios_ser:get_mem_silk(1)
    lu.assertEquals(objs, {{'mem_silk_obj'}})

    local obj = bios_ser.bios_object_collection[1]
    bios_ser.bios_object_collection[1] = {
        add_memsilk = function ()
        end
    }
    ok = pcall(function ()
        bios_ser:add_mem_silk_from_cache(1)
    end)
    lu.assertEquals(ok, true)
    bios_ser.bios_object_collection[1] = obj
end