-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local customize_cfg_handler = require 'handler.customize_cfg'
local bios_factory = require 'factory.bios_factory'

test_customize_conf = {}

function test_customize_conf:test_multihost_custom_import_data()
    local config = {
        CustomSettings = {
            BMCSet_BootDevice = {
                Value = 0
            },
            BMCSet_BootEffectMode = {
                Value = 0
            }
        }
    }
    local is_multihost = true
    local ok, _ = pcall(function ()
        customize_cfg_handler.config_import_data(config, is_multihost)
    end)
    lu.assertEquals(ok, true)
    ok, _ = pcall(function ()
        customize_cfg_handler.config_export_data(config, is_multihost)
    end)
    lu.assertEquals(ok, true)
end

function test_customize_conf:test_multihost_custom_import_all()
    local bios_service = bios_factory.get_service('bios_service')
    local get_all_objs = bios_service.get_all_objs
    bios_service.get_all_objs = function ()
        local objs = {
            [1] = {
                system_id = 1
            }
        }
        return objs
    end
    local is_multihost = true
    local config = {
        BMCBiosConfig = {
            {
                SystemId = {
                    Value = 1
                },
                BootOption = {},
                SmBios = {}
            }
        },
        CustomSettings = {
            BMCSet_BootDevice = {
                Value = 0,
                AttributeType = "ImportAndExport"
            },
            BMCSet_BootEffectMode = {
                Value = 0,
                AttributeType = "ImportAndExport"
            }
        }
    }
    local ok, _ = pcall(function ()
        customize_cfg_handler.config_import_data(config, is_multihost)
    end)
    lu.assertEquals(ok, true)
    ok, _ = pcall(function ()
        customize_cfg_handler.config_export_data(config, is_multihost)
    end)
    lu.assertEquals(ok, true)
    bios_service.get_all_objs = get_all_objs
end

function test_customize_conf:test_custom_import_data()
    local is_multihost = false
    local config = {
        CustomSettings = {
            BMCSet_BootDevice = {
                Value = 0
            },
            BMCSet_BootEffectMode = {
                Value = 0
            }
        }
    }
    local ok, _ = pcall(function ()
        customize_cfg_handler.config_import_data(config, is_multihost)
    end)
    lu.assertEquals(ok, true)
    ok, _ = pcall(function ()
        customize_cfg_handler.config_export_data(config, is_multihost)
    end)
    lu.assertEquals(ok, true)
end

