-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local config_check = require 'util.check.config_check'
local prop_def = require 'macros.property_def'
local cfg = require 'pojo.config.basic.configure'
local lu = require 'luaunit'

TestConfigCheck = {}


local function load_attribute_string()
    local cfgs = {}
    cfgs['MaxLength'] = 10
    cfgs['Minlength'] = 0
    cfgs['ValueExpression'] = 'test'

    return cfg.Attribute.new(cfgs)
end

local function load_attribute_number()
    local cfgs = {}
    cfgs['MaxLength'] = 10
    cfgs['Minlength'] = 0
    cfgs['ValueExpression'] = 123

    return cfg.Attribute.new(cfgs)
end

function TestConfigCheck:test_string_check()
    local attr = load_attribute_string()
    local res = config_check.StringCheck.check_type(attr, 'string')
    lu.assertEquals(res, prop_def.E_OK)

    attr = load_attribute_number()
    res = config_check.StringCheck.check_type(attr, 'string')
    lu.assertEquals(res, prop_def.E_FAILURE)
end