-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_service = require 'service.bios_service'
local ipmi = require 'ipmi'
local open_db = require 'bios.db'

local comp_code = ipmi.types.Cc

TestBiosVersion = {}

function TestBiosVersion:test_judge_req()
    local req = nil
    local ret = bios_service.judge_req(req)

    assert(ret == -1)

    local req = {ManufactureId = 0x0007DB}
    local ret = bios_service.judge_req(req)

    assert(ret == 1)

end

function TestBiosVersion:test_judge_manu_id_valid()
    local req = {}
    local manu_id = 0x0007DB
    local ret = bios_service.judge_manu_id_valid(req, manu_id)
    assert(ret == -1)

    local req = {ManufactureId = 0x0007CC}
    local ret = bios_service.judge_manu_id_valid(req, manu_id)
    assert(ret == -1)

    local req = {ManufactureId = 0x0007DB}
    local ret = bios_service.judge_manu_id_valid(req, manu_id)
    assert(ret == 1)
end

function TestBiosVersion:test_judge_version_valid()
    local req = {}
    local ret = bios_service.judge_version_valid(req)
    assert(ret == -1)

    local req = {Version = ''}
    local ret = bios_service.judge_version_valid(req)
    assert(ret == -1)

    local req = {Version = '99'}
    local ret = bios_service.judge_version_valid(req)
    assert(ret == 1)
end

local function construct_db()
    local ok, datas = pcall(require, 'bios.datas')
    if not ok then
        -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
        datas = nil
    end
    local db = open_db(':memory:', datas)
    return db
end

function TestBiosVersion:test_update_bios_version()
    local bios_ser = bios_service.new({}, construct_db())
    bios_ser:add_object({
        get_system_id = function()
            return 1
        end,
        register_mdb_objects = function ()
        end,
        unregister_mdb_objects = function ()
        end,
        PcieCardBDF = '',
        PcieDiskBDF = '',
        OCPCardBDF = '',
        Slot = 1
    })
    local req = nil
    local data = bios_ser:update_bios_version(req, {})
    assert(data)
    assert(data.CompletionCode == comp_code.InvalidFieldRequest)
    assert(data.ManufactureId == 0x0007DB)

    local req = {ManufactureId = 0x0007CC}
    local data = bios_ser:update_bios_version(req, {})
    assert(data)
    assert(data.CompletionCode == comp_code.InvalidCommand)
    assert(data.ManufactureId == 0x0007DB)

    local req = {Version = ''}
    local data = bios_ser:update_bios_version(req, {})
    assert(data)
    assert(data.CompletionCode == comp_code.InvalidCommand)
    assert(data.ManufactureId == 0x0007DB)
end