-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_app = require 'bios_app'
local bios_service = require 'service.bios_service'
local lu = require 'luaunit'

TestBiosApp = {}

function TestBiosApp:test_on_add_object_extra()
    local class_name = 'SPIChannel'
    local object = {
        Channel = 1,
        ObjectName = 'SPIChannel'
    }
    bios_app.bios_service = bios_service
    local c_spi_channel = bios_app.bios_service.spi_channel
    bios_app:on_add_object_extra(class_name, object)
    lu.assertEquals(bios_app.bios_service.spi_channel.Channel, 1)
    bios_app.bios_service.spi_channel = c_spi_channel

    class_name = 'BIOSMultihostConfig'
    object = {
        ObjectName = 'BIOSMultihostConfig'
    }
    bios_app:on_add_object_extra(class_name, object)

    class_name = 'SystemFirmwareProgress'
    object = {
        ObjectName = 'SystemFirmwareProgress',
        register_mdb_objects = function()
            return true
        end
    }
    local c_peripherals_device = bios_app.peripherals_device
    bios_app.peripherals_device = {
        add_object = function()
            return true
        end
    }
    bios_app:on_add_object_extra(class_name, object)
    bios_app.peripherals_device = c_peripherals_device
end