-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

loadfile(os.getenv('CONFIG_FILE'), 't', {package = package, os = os})()
package.path = '../test_utils/?.lua;' .. package.path

local utils = require 'utils.core'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)
logging:set_debug_log_type(logging.OUT_TYPE_LOCAL)

local lu = require('luaunit')

require 'test_write_smbios'
require 'test_bios_version'
require 'test_universal_interface'
require 'test_write_bios'
require 'test_write_bdf'
require 'test_export_bios_config'
require 'test_read_from_bmc'
require 'test_file_object'
require 'test_import_bios_config'
require 'test_boot_mode'
require 'test_ipmi_option'
require 'test_bios_conf'
require 'test_json_setup'
require 'upgrade.test_channel'
require 'upgrade.test_insfrastructure'
require 'upgrade.test_state_machine'
require 'upgrade.test_package'
require 'upgrade.test_service'
require 'test_flash'
require 'test_config'
require 'upgrade.test_multihost'
require 'test_customize_conf'
require 'test_report_alarm'
require 'test_memsilk_load'
require 'test_smbios_decoder'
require 'test_dump_info'
require 'test_multihost_card_config'
require 'test_config_check'
require 'test_system_info'
require 'upgrade.test_signal'
require 'test_mem_silk'
require 'test_alarm_manager'
require 'test_poweron_delay'
require 'test_bios_service'
require 'test_bios_app'
require 'test_write_to_bmc'
os.exit(lu.LuaUnit.run())
