-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local client = require 'bios.client'
local bs_util = require 'util.base_util'
local poweron_delay = require 'pojo.boot.poweron_delay'

local test_poweron_delay = {}
function test_poweron_delay.prepare_data()
    client.GetDelayedPowerOnPolicyObjects = function()
        -- 打桩资源树对象
        return {{Mode = 0, path='/bmc/kepler/Systems/1', Seconds = 50}}
    end
    bs_util.get_obj_id = function(path)
       return tonumber(string.match(path, '/bmc/kepler/Systems/(%d+)'))
    end
end

function test_poweron_delay.test_get_info()
    test_poweron_delay.prepare_data()
    local config_data = '\x00\x00'
    local ok, err = pcall(poweron_delay.get_info, poweron_delay, config_data, 1)
    assert(ok, err)
end

return test_poweron_delay