-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local test_bios_mode = {}
require 'ipmi'
local bs = require 'mc.bitstring'
local log = require 'mc.logging'
local BIOS_OPTION_PATH = '/bmc/kepler/Systems/1/BootOptions'
local BIOS_OPTION_INTERFACE = 'bmc.kepler.Systems.BootOptions'
local mdb = require 'mc.mdb'
local base_messages = require 'messages.base'
local lu = require 'luaunit'
local test_bios_common = require 'test_bios_common'

require 'bios.json_types.BootOptions'
require 'bios.json_types.Bios'

local WRITE_MODE_DATA_RSP = '<<ParameterVersion, BootOptionSelector, ConfigurationData/string>>'

local function send_ipmi(data)
    return test_bios_common.send_ipmi(data)
end

function test_bios_mode.test_get_boot_option()
    local ok, rsp = send_ipmi('0x00 0x09 0x00 0x00 0x00')
    if ok then
        local data = bs.new(WRITE_MODE_DATA_RSP):unpack(rsp)
        assert(data.ParameterVersion == 1)
        assert(data.BootOptionSelector ~= nil)
        assert(data.ConfigurationData ~= nil)
    end
end

function test_bios_mode.test_set_boot_mode(bus)
    local obj = mdb.get_object(bus, BIOS_OPTION_PATH, BIOS_OPTION_INTERFACE)
    local _, resp = pcall(function()
        obj:SetBootMode_PACKED(require'mc.context'.new(), "LEACY")
    end)
    lu.assertEquals(resp.name, base_messages.PropertyValueNotInListMessage.Name)
end

function test_bios_mode.test_mode(bus)
    log:info('================ test bios mode start ================')
    test_bios_mode.test_set_boot_mode(bus)
    test_bios_mode.test_get_boot_option()
    log:info('================ test bios mode end ================')
end

return test_bios_mode
