-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local opt = require "util.operator.operation"
local singleton = require 'mc.singleton'
local Class = require 'mc.class'
local prop_def = require 'macros.property_def'
local operation_strategy = Class()

function operation_strategy:init()
    self.opt_map = {}
    self.opt_map[prop_def.NUMBER_TYPE] = opt.IntegerOperation.new()
    self.opt_map[prop_def.BOOLEAN_TYPE] = opt.BooleanOperation.new()
    self.opt_map[prop_def.STRING_TYPE] = opt.StringOperation.new()
end

function operation_strategy:deal(op_type, obj1, obj2)
    local data_type = type(obj1)
    local data_type2 = type(obj2)
    if data_type ~= data_type2 then
        return false
    end

    if data_type == 'nil' and data_type == data_type2 and op_type == prop_def.REGRIST_PROP_COMPARE_EQU then
        return true
    end

    if not self.opt_map[data_type] then
        return false
    end

    return self.opt_map[data_type]:operator(op_type, obj1, obj2)
end

return singleton(operation_strategy)