-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local cfg_check = require "util.check.config_check"
local singleton = require 'mc.singleton'
local Class = require 'mc.class'
local prop_def = require 'macros.property_def'
local log = require 'mc.logging'

local check_strategy = Class()

function check_strategy:init()
    self.check_map = {}
    self.check_map[prop_def.REGRIST_PROP_TYPE_ENUM] = cfg_check.EnumCheck.new()
    self.check_map[prop_def.REGRIST_PROP_TYPE_STRING] = cfg_check.StringCheck.new()
    self.check_map[prop_def.REGRIST_PROP_TYPE_INTEGER] = cfg_check.IntegerCheck.new()
    self.check_map[prop_def.REGRIST_PROP_TYPE_BOOLEAN] = cfg_check.BooleanCheck.new()
    self.check_map[prop_def.REGRIST_PROP_TYPE_PASSWORD] = cfg_check.PasswordCheck.new()
end

function check_strategy:is_config_valid(type, attribute, value)
    if self.check_map[type] == nil then
        log:error("check_strategy:is_config_valid, type(%s) invalid", type)
        return prop_def.E_FAILURE
    end

    return self.check_map[type]:is_config_valid(attribute, value)
end

return singleton(check_strategy)