-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local file_op = require "service.file.file_operation_impl"
local prop = require "macros.property_def"
local singleton = require 'mc.singleton'
local bios_enum = require 'bios.types.enums'

local file_operation_strategy = class()

function file_operation_strategy:init()
    local op_map = {}
    op_map[prop.BIOS_FILE_SETUP_NUM] = file_op.OperationMenuData
    op_map[prop.BIOS_FILE_CLP] = file_op.OperationClp
    op_map[prop.BIOS_FILE_CURRENT_SECUREBOOT_NUM] = file_op.OperationSecureBoot
    op_map[0xFF] = file_op.OperationFile

    self.op_map = op_map
end

function file_operation_strategy:write_data(bios_obj, file_selector, data_opt)
    local index = file_selector
    if not self.op_map[index] then
        index = 0xFF
    end

    local strategy = self.op_map[index]
    if not strategy then
        local err_code = bios_enum.BiosErrCode.BIOS_ERR_INVALID_STATUS:value()
        return err_code
    end

    return self.op_map[index].write_data(bios_obj, file_selector, data_opt)
end

return singleton(file_operation_strategy)