-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'

local multihost_cfg_obj = class()

function multihost_cfg_obj:ctor(obj)
    self.mds_obj = obj
    self.configs = {}
end

local function config_new(SlotId, Bus, Device, Function, MultihostIds)
    return { SlotId = SlotId, Bus = Bus, Device = Device, Function = Function, MultihostIds = MultihostIds }
end

local function array_to_table(arr)
    local tb = {}
    for _, v in pairs(arr) do
        tb[v] = v
    end
    return tb
end

function multihost_cfg_obj:init()
    if not self.mds_obj.Maps or not next(self.mds_obj.Maps) or not next(self.mds_obj.Maps[1]) then
        return
    end
    local str_key = ''
    for i, config in ipairs(self.mds_obj.Maps) do
        self.mds_obj.Maps[i] = config_new(table.unpack(config))

        -- 初始化 configs
        log:notice('[multihost_cfg_obj] SlotId=%s, Bus=%s, Device=%s, Function=%s',
            self.mds_obj.Maps[i].SlotId, self.mds_obj.Maps[i].Bus, self.mds_obj.Maps[i].Device,
            self.mds_obj.Maps[i].Function)
        str_key = string.format('%s_%s_%s_%s', self.mds_obj.Maps[i].SlotId,
            self.mds_obj.Maps[i].Bus, self.mds_obj.Maps[i].Device, self.mds_obj.Maps[i].Function)
        log:notice(self.mds_obj.Maps[i].MultihostIds)
        self.configs[str_key] = array_to_table(self.mds_obj.Maps[i].MultihostIds)
    end
end

return multihost_cfg_obj