-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local base_utl = require "util.base_util"

local setting = class()

function setting:ctor(cfgs)
    self.Cfgs = base_utl.clone(cfgs)
end

function setting:get_cfgs()
    return self.Cfgs
end

function setting:destroy()
    if not self.Cfgs then
        return
    end
    for k, _ in pairs(self.Cfgs) do
        self.Cfgs[k] = nil
    end
    self.Cfgs = nil
end

function setting:set_attributes(cfgs)
    if not self.Cfgs then
        return
    end

    self.Cfgs = cfgs
end

function setting:get_val_by_name(setting_name)
    if not self.Cfgs then
        return nil
    end

    return self.Cfgs[setting_name]
end

return setting