-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local base_utl = require "util.base_util"
local class = require "mc.class"

local abstract_configure = class()

function abstract_configure:ctor(cfgs)
    self.Cfgs = base_utl.clone(cfgs)
end

function abstract_configure:get_cfgs()
    return self.Cfgs
end

function abstract_configure:set_cfgs(cfgs)
    self.Cfgs = cfgs
end

function abstract_configure:destroy()
    if not self.Cfgs then
        return
    end
    for k, _ in pairs(self.Cfgs) do
        self.Cfgs[k] = nil
    end
    self.Cfgs = nil
end

function abstract_configure:get_val_by_name(attr_name)
    if not attr_name or not self.Cfgs then
        return nil
    end

    return self.Cfgs[attr_name]
end

function abstract_configure:set_val_by_name(attr_name, attr_val)
    if not attr_name or not self.Cfgs then
        return
    end

    self.Cfgs[attr_name] = attr_val
end

return abstract_configure