-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local prop_def = require 'macros.property_def'
local base_messages = require 'messages.base'
local custom_messages = require 'messages.custom'
local error_engineer = {}

local error_config_type
local val1
local val2
local registry_handler
local error_type = {}

local error_deal_map = {
    [prop_def.REGRIST_TYPE_PROP_NOT_LIST] = function(...)
        error(base_messages.PropertyValueNotInList(...))
    end,
    [prop_def.REGRIST_TYPE_PROP_LENGTH_ERR] = function(...)
        error(base_messages.PropertyValueFormatError(...))
    end,
    [prop_def.REGRIST_TYPE_PROP_NOT_RANGE] = function(_, attr_name)
        error(custom_messages.ValueOutOfRange(attr_name))
    end,
    [prop_def.REGRIST_TYPE_PROP_TYPE_ERROR] = function(...)
        error(base_messages.PropertyValueTypeError(...))
    end,
    [prop_def.REGRIST_TYPE_PROP_SCALAR_INCREMENT] = function(...)
        error(custom_messages.PropertyScalarIncrement(...))
    end,
    [prop_def.RESPONSE_BOOTTYPEORDER_ERROR] = function(...)
        error(custom_messages.SettingBootOrderFailed(...))
    end,
    [prop_def.REGRIST_INTERNEL_ERROR] = function()
        error(base_messages.InternalError())
    end
}

function error_engineer.init(handler)
    registry_handler = handler
end

function error_engineer.set_error(arg1, arg2, arg3)
    error_config_type = arg1
    val1 = arg2
    val2 = arg3
end

function error_engineer.add_status_error(type, attr_name)
    error_config_type = nil
    error_type['Type'] = type
    error_type['AttributeName'] = attr_name
end

function error_engineer.throws_config_exception()
    local error_fun = error_deal_map[error_config_type]
    if error_fun then
        error_fun(val1, val2)
    else
        error(base_messages.InternalError())
    end
end

function error_engineer.throws_exception()
    if error_config_type then
        registry_handler = nil
        error_engineer.throws_config_exception()
    end
    error_engineer.throws_status_error(error_type['Type'], error_type['AttributeName'])
end

-- 根据不同错误类型生成不同的错误
function error_engineer.throws_status_error(type, attr_name)
    if not type or not attr_name then
        error(base_messages.InternalError())
    end

    if type == prop_def.REGRIST_PROP_IMMUTABLE then
        error(custom_messages.PropertyImmutable())
    end

    local err_msg = registry_handler:get_dependency_msg(type, attr_name)
    registry_handler = nil
    local log_attr = 'Attributes/' .. attr_name
    if type == prop_def.REGRIST_PROP_READONLY then
        if not err_msg then
            error(base_messages.PropertyNotWritable(log_attr))
        else
            error(custom_messages.SettingPropertyFailedExtend(log_attr, err_msg))
        end
    elseif type == prop_def.REGRIST_PROP_HIDDEN then
        if not err_msg then
            error(custom_messages.SettingPropertyFailed(log_attr, log_attr, 'hidden'))
        else
            error(custom_messages.SettingPropertyFailedExtend(log_attr, err_msg))
        end
    end

    error(base_messages.InternalError())
end

return error_engineer