-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local boot_def = require 'macros.boot_def'
local prop_def = require 'macros.property_def'

local effective_time_handler = class()

local function judge_data(data)
    if not data or not data[0] or type(data[0]) ~= prop_def.NUMBER_TYPE then
        return false
    end

    return true
end

local t_effective_none_handler = class()
function t_effective_none_handler.handle(data)
    if not judge_data(data) then
        return false
    end

    data[0] = data[0] & 0xff
    data[0] = data[0] & (~(boot_def.PBIT7))
    data[0] = data[0] & 0xff
    return true
end

effective_time_handler.effective_none_handler = t_effective_none_handler

local t_effective_once_handler = class()
function t_effective_once_handler.handle(data)
    if not judge_data(data) then
        return false
    end

    data[0] = data[0] & 0xff
    data[0] = data[0] | boot_def.PBIT7
    local bit6 = (~(boot_def.PBIT6)) & 0xff
    data[0] = data[0] & bit6
    data[0] = data[0] & 0xff
    return true
end

effective_time_handler.effective_once_handler = t_effective_once_handler

local t_effective_forever_handler = class()
function t_effective_forever_handler.handle(data)
    if not judge_data(data) then
        return false
    end

    data[0] = data[0] & 0xff
    data[0] = data[0] | boot_def.PBIT7
    data[0] = data[0] | boot_def.PBIT6
    data[0] = data[0] & 0xff
    return true
end

effective_time_handler.effective_forever_handler = t_effective_forever_handler

return effective_time_handler