-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local config_util = {}

local trans_bmc_prop_map = {
    ['StartOption'] = 'BootSourceOverrideTarget',
    ['StartOptionFlag'] = 'BootSourceOverrideEnabled',
    ['StartOptionFlagExt'] = 'BootSourceOverrideEnabled',
    ['BiosBootMode'] = 'BootSourceOverrideMode',
    ['BiosBootModeSw'] = 'BootModeSupport',
    ['BiosBootModeSwEnable'] = 'BootModeIpmiSettable'
}

local trans_user_map ={
    ['StartOption'] = {
        ['None'] = 'No Override',
        ['Pxe'] = 'PXE',
        ['Hdd'] = 'Hard Drive',
        ['Cd'] = 'DVD-ROM',
        ['BiosSetup'] = 'BIOS Setup',
        ['Floppy'] = 'FDD/Removable Device'
    },
    ['StartOptionFlag'] = {
        ['Disabled'] = 'One-time',
        ['Once'] = 'One-time',
        ['Continuous'] = 'Permanent'
    },
    ['StartOptionFlagExt'] = {
        ['Disabled'] = 'One-time-0',
        ['Once'] = 'One-time-1',
        ['Continuous'] = 'Permanent'
    },
    ['BiosBootModeSw'] = {
        [true] = 1,
        [false] = 0
    },
    ['BiosBootMode'] = {
        ["UEFI"] = 1
    },
    ['BiosBootModeSwEnable'] = {
        [true] = 1,
        [false] = 0
    }
}

-- 属性转化成bmc存储格式的表
local trans_bmc_map ={
    ['StartOption'] = {
        ['No Override'] = 0,
        ['PXE'] = 1,
        ['Hard Drive'] = 2,
        ['DVD-ROM'] = 5,
        ['BIOS Setup'] = 6,
        ['FDD/Removable Device'] = 15
    },
    ['StartOptionFlag'] = {
        ['One-time'] = 1,
        ['Permanent'] = 2
    },
    ['StartOptionFlagExt'] = {
        ['One-time-0'] = 0,
        ['One-time-1'] = 1,
        ['Permanent'] = 2
    },
    ['BiosBootModeSw'] = {
        [0] = false,
        [1] = true
    },
    ['BiosBootModeSwEnable'] = {
        [0] = false,
        [1] = true
    }
}

-- 将用户导入的配置名转换为bmc的存储格式
function config_util.get_bmc_prop(prop)
    local prop_bmc = trans_bmc_prop_map[prop]
    if prop_bmc ~= nil then
        return prop_bmc
    end
    return prop
end

-- 将bmc属性值的存储格式转换为用户导入的配置值
function config_util.get_user_prop_val(prop, val)
    local user_prop_vals = trans_user_map[prop]
    if user_prop_vals then
        return user_prop_vals[val]
    end
    return val
end

-- 将用户导入的配置值转换为bmc属性值的存储格式
function config_util.get_bmc_prop_val(prop, val)
    local bmc_prop_vals = trans_bmc_map[prop]
    if bmc_prop_vals then
        return bmc_prop_vals[val]
    end
    return val
end

function config_util.is_need_import(val_json, current_val)
    if not val_json['Import'] then
        return false
    end
    local import_val = val_json['Value']
    if current_val == import_val then
        return false
    end
    return true
end

return config_util