-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: imu通信的相关工具
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local compt_effective = require 'domain.transport.component_effective'
local compt_info_query = require 'domain.transport.component_info_query'
local component_upgrade = require 'domain.transport.component_upgrade'
local component_process_query = require 'domain.transport.component_process_query'
local component_send_confirmed = require 'domain.transport.component_send_confirmed'

local ImuCommunicate = class()

-- 门面
function ImuCommunicate:ctor()
    self.component_info_query = compt_info_query.new()
    self.component_effective = compt_effective.new()
    self.component_process_query = component_process_query.new()
    self.component_send_confirmed = component_send_confirmed.new()
end

function ImuCommunicate:activate(bitmap, system_id)
    return self.component_effective:activate(bitmap, system_id)
end

function ImuCommunicate:get_verification_info(type, system_id)
    return self.component_info_query:get_verification_info(type, system_id)
end

function ImuCommunicate:get_info(type, system_id)
    return self.component_info_query:get_info(type, system_id)
end

function ImuCommunicate:query_firmware_process_status(system_id)
    return self.component_process_query:get_process_status(system_id)
end

function ImuCommunicate:write_firmware(data, system_id)
    local compt_upgrade = component_upgrade.new()
    return compt_upgrade:write(data, system_id)
end

function ImuCommunicate:confirm_send_state(state, system_id)
    self.component_send_confirmed:confirm(state, system_id)
end

return singleton(ImuCommunicate)