-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 固件升级状态查询
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local component_communicate = require 'domain.transport.component_communicate'

local ComponentProcessQuery = class(component_communicate)

-- 管理版本
-- 1、固件版本信息管理
-- 2、固件版本存储的文件管理

-- 查询校验信息
local msg = {
    Header = {
        DestNetFn = '',
        Cmd = ''
    },
    Data = {
        SubCmd = 0x25
    },
    SendFormat = [[<<0xDB0700:3/unit:8, SubCmd>>]],
    ReceiveFormat = [[<<ManuId:3/unit:8, Status, ErrorCode>>]]
}

function ComponentProcessQuery:get_process_status(system_id)
    msg.Header.DestNetFn = self.defs.netfn.OemReqNetfn
    msg.Header.Cmd = self.defs.cmd.ImuCmd
    msg.SystemId = system_id
    return self:retry_send_and_receive_msg(msg)
end


return singleton(ComponentProcessQuery)