-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 固件生效
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local component_communicate = require 'domain.transport.component_communicate'

local ComponentEffective = class(component_communicate)

function ComponentEffective:activate(bitmap, system_id)
    local msg = {
        Header = {
            DestNetFn = self.defs.netfn.OemReqNetfn,
            Cmd = self.defs.cmd.ImuCmd
        },
        Data = {
            SubCmd = 0x24,
            Mode = bitmap,
            Reserved = 0x00
        },
        SendFormat = [[<<0xDB0700:3/unit:8, SubCmd, Mode, Reserved:3/unit:8>>]],
        SystemId = system_id
    }
    self.imu_cmd:send_with_error_code(msg)
    log:notice('[bios]firmware activate: activate success')
end

return singleton(ComponentEffective)